/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.data.impl;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nullable;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Sone;

public class ImageImpl
implements Image {
    private final String id;
    private Sone sone;
    private Album album;
    private String key;
    private long creationTime;
    private int width;
    private int height;
    private String title;
    private String description;

    public ImageImpl() {
        this(UUID.randomUUID().toString());
        this.creationTime = System.currentTimeMillis();
    }

    public ImageImpl(String id) {
        this.id = Preconditions.checkNotNull(id, "id must not be null");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Sone getSone() {
        return this.sone;
    }

    @Override
    public Album getAlbum() {
        return this.album;
    }

    @Override
    public Image setAlbum(Album album) {
        Preconditions.checkNotNull(album, "album must not be null");
        Preconditions.checkNotNull(album.getSone().equals(this.getSone()), "album must belong to the same Sone as this image");
        this.album = album;
        return this;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isInserted() {
        return this.key != null;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Image.Modifier modify() throws IllegalStateException {
        return new Image.Modifier(){
            @Nullable
            private Sone sone;
            @Nullable
            private Long creationTime;
            @Nullable
            private String key;
            @Nullable
            private String title;
            @Nullable
            private String description;
            @Nullable
            private Integer width;
            @Nullable
            private Integer height;

            @Override
            public Image.Modifier setSone(Sone sone) {
                this.sone = sone;
                return this;
            }

            @Override
            public Image.Modifier setCreationTime(long creationTime) {
                this.creationTime = creationTime;
                return this;
            }

            @Override
            public Image.Modifier setKey(String key) {
                this.key = key;
                return this;
            }

            @Override
            public Image.Modifier setTitle(String title) {
                this.title = title;
                return this;
            }

            @Override
            public Image.Modifier setDescription(String description) {
                this.description = description;
                return this;
            }

            @Override
            public Image.Modifier setWidth(int width) {
                this.width = width;
                return this;
            }

            @Override
            public Image.Modifier setHeight(int height) {
                this.height = height;
                return this;
            }

            @Override
            public Image update() throws IllegalStateException {
                Preconditions.checkState(this.sone == null || ImageImpl.this.sone == null || this.sone.equals(ImageImpl.this.sone), "can not change Sone once set");
                Preconditions.checkState(this.creationTime == null || ImageImpl.this.creationTime == 0L || ImageImpl.this.creationTime == this.creationTime, "can not change creation time once set");
                Preconditions.checkState(this.key == null || ImageImpl.this.key == null || this.key.equals(ImageImpl.this.key), "can not change key once set");
                if (this.title != null && this.title.trim().isEmpty()) {
                    throw new Image.Modifier.ImageTitleMustNotBeEmpty();
                }
                Preconditions.checkState(this.width == null || ImageImpl.this.width == 0 || this.width.equals(ImageImpl.this.width), "can not change width once set");
                Preconditions.checkState(this.height == null || ImageImpl.this.height == 0 || this.height.equals(ImageImpl.this.height), "can not change height once set");
                if (this.sone != null) {
                    ImageImpl.this.sone = this.sone;
                }
                if (this.creationTime != null) {
                    ImageImpl.this.creationTime = this.creationTime;
                }
                if (this.key != null) {
                    ImageImpl.this.key = this.key;
                }
                if (this.title != null) {
                    ImageImpl.this.title = this.title;
                }
                if (this.description != null) {
                    ImageImpl.this.description = this.description;
                }
                if (this.width != null) {
                    ImageImpl.this.width = this.width;
                }
                if (this.height != null) {
                    ImageImpl.this.height = this.height;
                }
                return ImageImpl.this;
            }
        };
    }

    @Override
    public String getFingerprint() {
        Hasher hash = Hashing.sha256().newHasher();
        hash.putString("Image(", StandardCharsets.UTF_8);
        hash.putString("ID(", StandardCharsets.UTF_8).putString(this.id, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString("Title(", StandardCharsets.UTF_8).putString(this.title, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString("Description(", StandardCharsets.UTF_8).putString(this.description, StandardCharsets.UTF_8).putString(")", StandardCharsets.UTF_8);
        hash.putString(")", StandardCharsets.UTF_8);
        return hash.hash().toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageImpl)) {
            return false;
        }
        return ((ImageImpl)object).id.equals(this.id);
    }
}

