/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.database.BookmarkDatabase;
import net.pterodactylus.sone.database.memory.ConfigurationLoader;
import net.pterodactylus.sone.database.memory.MemoryDatabase;

public class MemoryBookmarkDatabase
implements BookmarkDatabase {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MemoryDatabase memoryDatabase;
    private final ConfigurationLoader configurationLoader;
    private final Set<String> bookmarkedPosts = new HashSet<String>();

    public MemoryBookmarkDatabase(MemoryDatabase memoryDatabase, ConfigurationLoader configurationLoader) {
        this.memoryDatabase = memoryDatabase;
        this.configurationLoader = configurationLoader;
    }

    public void start() {
        this.loadBookmarkedPosts();
    }

    private void loadBookmarkedPosts() {
        Set<String> bookmarkedPosts = this.configurationLoader.loadBookmarkedPosts();
        this.lock.writeLock().lock();
        try {
            this.bookmarkedPosts.clear();
            this.bookmarkedPosts.addAll(bookmarkedPosts);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stop() {
        this.saveBookmarkedPosts();
    }

    private void saveBookmarkedPosts() {
        this.lock.readLock().lock();
        try {
            this.configurationLoader.saveBookmarkedPosts(this.bookmarkedPosts);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void bookmarkPost(Post post) {
        this.lock.writeLock().lock();
        try {
            this.bookmarkedPosts.add(post.getId());
            this.saveBookmarkedPosts();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void unbookmarkPost(Post post) {
        this.lock.writeLock().lock();
        try {
            this.bookmarkedPosts.remove(post.getId());
            this.saveBookmarkedPosts();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isPostBookmarked(Post post) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bookmarkedPosts.contains(post.getId());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<Post> getBookmarkedPosts() {
        this.lock.readLock().lock();
        try {
            ImmutableSet<Post> immutableSet = FluentIterable.from(this.bookmarkedPosts).transform(new Function<String, Post>(){

                @Override
                public Post apply(String postId) {
                    return Optional.fromNullable(MemoryBookmarkDatabase.this.memoryDatabase.getPost(postId)).or(new Post.EmptyPost(postId));
                }
            }).toSet();
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

