/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.RateLimiter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.AlbumKt;
import net.pterodactylus.sone.data.Identified;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Reply;
import net.pterodactylus.sone.data.ReplyKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.data.impl.AlbumBuilderImpl;
import net.pterodactylus.sone.data.impl.ImageBuilderImpl;
import net.pterodactylus.sone.database.AlbumBuilder;
import net.pterodactylus.sone.database.Database;
import net.pterodactylus.sone.database.DatabaseException;
import net.pterodactylus.sone.database.ImageBuilder;
import net.pterodactylus.sone.database.PostBuilder;
import net.pterodactylus.sone.database.PostReplyBuilder;
import net.pterodactylus.sone.database.memory.ConfigurationLoader;
import net.pterodactylus.sone.database.memory.MemoryBookmarkDatabase;
import net.pterodactylus.sone.database.memory.MemoryDatabase;
import net.pterodactylus.sone.database.memory.MemoryFriendDatabase;
import net.pterodactylus.sone.database.memory.MemoryPostBuilder;
import net.pterodactylus.sone.database.memory.MemoryPostReplyBuilder;
import net.pterodactylus.sone.database.memory.MemorySoneBuilder;
import net.pterodactylus.sone.utils.BooleansKt;
import net.pterodactylus.sone.utils.ObjectsKt;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\bH\u0016J\u0010\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020\u000fH\u0016J\b\u0010J\u001a\u00020EH\u0014J\b\u0010K\u001a\u00020EH\u0014J\u0012\u0010L\u001a\u0004\u0018\u00010\t2\u0006\u0010M\u001a\u00020\bH\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010O\u001a\u00020\bH\u0016J\u0017\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010G\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010RJ\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\b0T2\u0006\u0010F\u001a\u00020\u0011H\u0016J\u0012\u0010U\u001a\u0004\u0018\u00010\u000b2\u0006\u0010V\u001a\u00020\bH\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010\u000f2\u0006\u0010X\u001a\u00020\bH\u0016J\u0012\u0010Y\u001a\u0004\u0018\u00010\r2\u0006\u0010Z\u001a\u00020\bH\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000f0T2\u0006\u00108\u001a\u00020\bH\u0016J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010X\u001a\u00020\bH\u0016J\u0012\u0010]\u001a\u0004\u0018\u00010\u00112\u0006\u00108\u001a\u00020\bH\u0016J\u0018\u0010^\u001a\u00020_2\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\bH\u0016J\u0010\u0010`\u001a\u00020_2\u0006\u0010I\u001a\u00020\u000fH\u0016J\u0010\u0010a\u001a\u00020_2\u0006\u0010I\u001a\u00020\u000fH\u0004J\u0010\u0010b\u001a\u00020_2\u0006\u0010c\u001a\u00020\rH\u0004J\b\u0010d\u001a\u00020EH\u0002J\b\u0010e\u001a\u00020_H\u0002J\b\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u00020iH\u0016J\b\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020mH\u0016J\b\u0010n\u001a\u00020oH\u0016J\u0010\u0010p\u001a\u00020E2\u0006\u0010q\u001a\u00020\tH\u0016J\u0018\u0010r\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\bH\u0016J\u0010\u0010s\u001a\u00020E2\u0006\u0010t\u001a\u00020\u000bH\u0016J\u0010\u0010u\u001a\u00020E2\u0006\u0010I\u001a\u00020\u000fH\u0016J\u0010\u0010v\u001a\u00020E2\u0006\u0010c\u001a\u00020\rH\u0016J\u0010\u0010w\u001a\u00020E2\u0006\u0010x\u001a\u00020\u0011H\u0016J\b\u0010y\u001a\u00020EH\u0016J\u000f\u0010z\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010{J\u000f\u0010|\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0002\u0010{J\u0016\u0010}\u001a\u00020E2\u0006\u0010I\u001a\u00020\u000f2\u0006\u0010~\u001a\u00020_J\u0010\u0010\u007f\u001a\u00020E2\u0006\u0010c\u001a\u00020\rH\u0016J\u0011\u0010\u0080\u0001\u001a\u00020E2\u0006\u0010q\u001a\u00020\tH\u0016J\u0011\u0010\u0081\u0001\u001a\u00020E2\u0006\u0010t\u001a\u00020\u000bH\u0016J\u0011\u0010\u0082\u0001\u001a\u00020E2\u0006\u0010I\u001a\u00020\u000fH\u0016J\u0011\u0010\u0083\u0001\u001a\u00020E2\u0006\u0010c\u001a\u00020\rH\u0016J\u0011\u0010\u0084\u0001\u001a\u00020E2\u0006\u0010x\u001a\u00020\u0011H\u0016J\u0011\u0010\u0085\u0001\u001a\u00020E2\u0006\u0010I\u001a\u00020\u000fH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001eR\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t02X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b02X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u00104\u001a\u001f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0006\u0012\u0004\u0018\u00010\u0011058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r02X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f02X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0015R\u001b\u0010?\u001a\u00020@8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010*\u001a\u0004\bA\u0010B\u00a8\u0006\u0086\u0001"}, d2={"Lnet/pterodactylus/sone/database/memory/MemoryDatabase;", "Lcom/google/common/util/concurrent/AbstractService;", "Lnet/pterodactylus/sone/database/Database;", "configuration", "Lnet/pterodactylus/util/config/Configuration;", "(Lnet/pterodactylus/util/config/Configuration;)V", "allAlbums", "", "", "Lnet/pterodactylus/sone/data/Album;", "allImages", "Lnet/pterodactylus/sone/data/Image;", "allPostReplies", "Lnet/pterodactylus/sone/data/PostReply;", "allPosts", "Lnet/pterodactylus/sone/data/Post;", "allSones", "Lnet/pterodactylus/sone/data/Sone;", "bookmarkedPosts", "", "getBookmarkedPosts", "()Ljava/util/Set;", "configurationLoader", "Lnet/pterodactylus/sone/database/memory/ConfigurationLoader;", "knownPostReplies", "", "knownPosts", "localSones", "", "getLocalSones", "()Ljava/util/List;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "memoryBookmarkDatabase", "Lnet/pterodactylus/sone/database/memory/MemoryBookmarkDatabase;", "memoryFriendDatabase", "Lnet/pterodactylus/sone/database/memory/MemoryFriendDatabase;", "readLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;", "getReadLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;", "readLock$delegate", "Lkotlin/Lazy;", "remoteSones", "getRemoteSones", "saveKnownPostRepliesRateLimiter", "Lcom/google/common/util/concurrent/RateLimiter;", "saveKnownPostsRateLimiter", "saveRateLimiter", "soneAlbums", "Lcom/google/common/collect/Multimap;", "soneImages", "soneLoader", "Lkotlin/reflect/KFunction1;", "Lkotlin/ParameterName;", "name", "soneId", "getSoneLoader", "()Lkotlin/reflect/KFunction;", "sonePostReplies", "sonePosts", "sones", "getSones", "writeLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "getWriteLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "writeLock$delegate", "addFriend", "", "localSone", "friendSoneId", "bookmarkPost", "post", "doStart", "doStop", "getAlbum", "albumId", "getDirectedPosts", "recipientId", "getFollowingTime", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getFriends", "", "getImage", "imageId", "getPost", "postId", "getPostReply", "id", "getPosts", "getReplies", "getSone", "isFriend", "", "isPostBookmarked", "isPostKnown", "isPostReplyKnown", "postReply", "loadKnownPostReplies", "loadKnownPosts", "newAlbumBuilder", "Lnet/pterodactylus/sone/database/AlbumBuilder;", "newImageBuilder", "Lnet/pterodactylus/sone/database/ImageBuilder;", "newPostBuilder", "Lnet/pterodactylus/sone/database/PostBuilder;", "newPostReplyBuilder", "Lnet/pterodactylus/sone/database/PostReplyBuilder;", "newSoneBuilder", "Lnet/pterodactylus/sone/database/memory/MemorySoneBuilder;", "removeAlbum", "album", "removeFriend", "removeImage", "image", "removePost", "removePostReply", "removeSone", "sone", "save", "saveKnownPostReplies", "()Lkotlin/Unit;", "saveKnownPosts", "setPostKnown", "known", "setPostReplyKnown", "storeAlbum", "storeImage", "storePost", "storePostReply", "storeSone", "unbookmarkPost", "Sone"})
public final class MemoryDatabase
extends AbstractService
implements Database {
    private final ReentrantReadWriteLock lock;
    private final Lazy readLock$delegate;
    private final Lazy writeLock$delegate;
    private final ConfigurationLoader configurationLoader;
    private final Map<String, Sone> allSones;
    private final Map<String, Post> allPosts;
    private final Multimap<String, Post> sonePosts;
    private final Set<String> knownPosts;
    private final Map<String, PostReply> allPostReplies;
    private final Multimap<String, PostReply> sonePostReplies;
    private final Set<String> knownPostReplies;
    private final Map<String, Album> allAlbums;
    private final Multimap<String, Album> soneAlbums;
    private final Map<String, Image> allImages;
    private final Multimap<String, Image> soneImages;
    private final MemoryBookmarkDatabase memoryBookmarkDatabase;
    private final MemoryFriendDatabase memoryFriendDatabase;
    private final RateLimiter saveRateLimiter;
    private final RateLimiter saveKnownPostsRateLimiter;
    private final RateLimiter saveKnownPostRepliesRateLimiter;
    private final Configuration configuration;

    private final ReentrantReadWriteLock.ReadLock getReadLock() {
        Lazy lazy = this.readLock$delegate;
        MemoryDatabase memoryDatabase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ReentrantReadWriteLock.ReadLock)lazy.getValue();
    }

    private final ReentrantReadWriteLock.WriteLock getWriteLock() {
        Lazy lazy = this.writeLock$delegate;
        MemoryDatabase memoryDatabase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ReentrantReadWriteLock.WriteLock)lazy.getValue();
    }

    @NotNull
    public KFunction<Sone> getSoneLoader() {
        return new Function1<String, Sone>(this){

            @Nullable
            public final Sone invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((MemoryDatabase)this.receiver).getSone(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MemoryDatabase.class);
            }

            public final String getName() {
                return "getSone";
            }

            public final String getSignature() {
                return "getSone(Ljava/lang/String;)Lnet/pterodactylus/sone/data/Sone;";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Sone> getSones() {
        Set<Sone> set;
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            set = CollectionsKt.toSet((Iterable)this.allSones.values());
        }
        finally {
            lock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Sone> getLocalSones() {
        List list;
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            void $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = this.allSones.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Sone p1 = (Sone)element$iv$iv;
                boolean bl3 = false;
                if (!p1.isLocal()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Sone> getRemoteSones() {
        List list;
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            void $this$filterNotTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$filterNot$iv = this.allSones.values();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Sone p1 = (Sone)element$iv$iv;
                boolean bl3 = false;
                if (p1.isLocal()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    @Override
    @NotNull
    public Set<Post> getBookmarkedPosts() {
        Set<Post> set = this.memoryBookmarkDatabase.getBookmarkedPosts();
        Intrinsics.checkExpressionValueIsNotNull(set, "memoryBookmarkDatabase.bookmarkedPosts");
        return set;
    }

    @Override
    public void save() {
        if (this.saveRateLimiter.tryAcquire()) {
            this.saveKnownPosts();
            this.saveKnownPostReplies();
        }
    }

    @Override
    protected void doStart() {
        this.memoryBookmarkDatabase.start();
        this.loadKnownPosts();
        this.loadKnownPostReplies();
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        try {
            this.memoryBookmarkDatabase.stop();
            this.save();
            this.notifyStopped();
        }
        catch (DatabaseException de1) {
            this.notifyFailed(de1);
        }
    }

    @Override
    @NotNull
    public MemorySoneBuilder newSoneBuilder() {
        return new MemorySoneBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSone(@NotNull Sone sone) {
        Intrinsics.checkParameterIsNotNull(sone, "sone");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.removeSone(sone);
            this.allSones.put(sone.getId(), sone);
            this.sonePosts.putAll(sone.getId(), (Iterable<Post>)sone.getPosts());
            for (Post post : sone.getPosts()) {
                String string = post.getId();
                Intrinsics.checkExpressionValueIsNotNull(string, "post.id");
                Post post2 = post;
                Intrinsics.checkExpressionValueIsNotNull(post2, "post");
                this.allPosts.put(string, post2);
            }
            this.sonePostReplies.putAll(sone.getId(), (Iterable<PostReply>)sone.getReplies());
            for (PostReply postReply : sone.getReplies()) {
                String string = postReply.getId();
                Intrinsics.checkExpressionValueIsNotNull(string, "postReply.id");
                PostReply postReply2 = postReply;
                Intrinsics.checkExpressionValueIsNotNull(postReply2, "postReply");
                this.allPostReplies.put(string, postReply2);
            }
            Collection<Identified> collection = SoneKt.getAllAlbums(sone);
            boolean bl3 = false;
            boolean bl4 = false;
            List<Album> albums = collection;
            boolean bl5 = false;
            this.soneAlbums.putAll(sone.getId(), (Iterable<Album>)albums);
            Iterable $this$forEach$iv = albums;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Album album = (Album)element$iv;
                boolean bl6 = false;
                String string = album.getId();
                Intrinsics.checkExpressionValueIsNotNull(string, "album.id");
                this.allAlbums.put(string, album);
            }
            Album album = sone.getRootAlbum();
            Intrinsics.checkExpressionValueIsNotNull(album, "sone.rootAlbum");
            collection = AlbumKt.getAllImages(album);
            bl3 = false;
            bl4 = false;
            Collection<Identified> images = collection;
            boolean bl7 = false;
            this.soneImages.putAll(sone.getId(), (Iterable<Image>)images);
            $this$forEach$iv = images;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Image image = (Image)element$iv;
                boolean bl8 = false;
                String string = image.getId();
                Intrinsics.checkExpressionValueIsNotNull(string, "image.id");
                this.allImages.put(string, image);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSone(@NotNull Sone sone) {
        Intrinsics.checkParameterIsNotNull(sone, "sone");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.allSones.remove(sone.getId());
            Collection<Post> removedPosts = this.sonePosts.removeAll(sone.getId());
            for (Post removedPost : removedPosts) {
                this.allPosts.remove(removedPost.getId());
            }
            Collection<PostReply> removedPostReplies = this.sonePostReplies.removeAll(sone.getId());
            for (PostReply removedPostReply : removedPostReplies) {
                this.allPostReplies.remove(removedPostReply.getId());
            }
            Collection<Album> removedAlbums = this.soneAlbums.removeAll(sone.getId());
            for (Album removedAlbum : removedAlbums) {
                this.allAlbums.remove(removedAlbum.getId());
            }
            Collection<Image> removedImages = this.soneImages.removeAll(sone.getId());
            for (Image removedImage : removedImages) {
                this.allImages.remove(removedImage.getId());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Sone getSone(@NotNull String soneId2) {
        Sone sone;
        Intrinsics.checkParameterIsNotNull(soneId2, "soneId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            sone = this.allSones.get(soneId2);
        }
        finally {
            lock.unlock();
        }
        return sone;
    }

    @Override
    @NotNull
    public Collection<String> getFriends(@NotNull Sone localSone) {
        Collection<String> collection;
        Intrinsics.checkParameterIsNotNull(localSone, "localSone");
        if (!localSone.isLocal()) {
            collection = SetsKt.emptySet();
        } else {
            Collection<String> collection2 = this.memoryFriendDatabase.getFriends(localSone.getId());
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "memoryFriendDatabase.getFriends(localSone.id)");
        }
        return collection;
    }

    @Override
    public boolean isFriend(@NotNull Sone localSone, @NotNull String friendSoneId) {
        Intrinsics.checkParameterIsNotNull(localSone, "localSone");
        Intrinsics.checkParameterIsNotNull(friendSoneId, "friendSoneId");
        return !localSone.isLocal() ? false : this.memoryFriendDatabase.isFriend(localSone.getId(), friendSoneId);
    }

    @Override
    public void addFriend(@NotNull Sone localSone, @NotNull String friendSoneId) {
        Intrinsics.checkParameterIsNotNull(localSone, "localSone");
        Intrinsics.checkParameterIsNotNull(friendSoneId, "friendSoneId");
        if (!localSone.isLocal()) {
            return;
        }
        this.memoryFriendDatabase.addFriend(localSone.getId(), friendSoneId);
    }

    @Override
    public void removeFriend(@NotNull Sone localSone, @NotNull String friendSoneId) {
        Intrinsics.checkParameterIsNotNull(localSone, "localSone");
        Intrinsics.checkParameterIsNotNull(friendSoneId, "friendSoneId");
        if (!localSone.isLocal()) {
            return;
        }
        this.memoryFriendDatabase.removeFriend(localSone.getId(), friendSoneId);
    }

    @Override
    @Nullable
    public Long getFollowingTime(@NotNull String friendSoneId) {
        Intrinsics.checkParameterIsNotNull(friendSoneId, "friendSoneId");
        return this.memoryFriendDatabase.getFollowingTime(friendSoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Post getPost(@NotNull String postId) {
        Post post;
        Intrinsics.checkParameterIsNotNull(postId, "postId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            post = this.allPosts.get(postId);
        }
        finally {
            lock.unlock();
        }
        return post;
    }

    @Override
    @NotNull
    public Collection<Post> getPosts(@NotNull String soneId2) {
        Intrinsics.checkParameterIsNotNull(soneId2, "soneId");
        Collection<Post> collection = this.sonePosts.get(soneId2);
        Intrinsics.checkExpressionValueIsNotNull(collection, "sonePosts[soneId]");
        return CollectionsKt.toSet((Iterable)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getDirectedPosts(@NotNull String recipientId) {
        List list;
        Intrinsics.checkParameterIsNotNull(recipientId, "recipientId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            void $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = this.allPosts.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Post it = (Post)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getRecipientId().orNull(), recipientId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    @Override
    @NotNull
    public PostBuilder newPostBuilder() {
        return new MemoryPostBuilder(this, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePost(@NotNull Post post) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        Preconditions.checkNotNull(post, "post must not be null", new Object[0]);
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            String string = post.getId();
            Intrinsics.checkExpressionValueIsNotNull(string, "post.id");
            this.allPosts.put(string, post);
            boolean bl3 = this.sonePosts.get(post.getSone().getId()).add(post);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePost(@NotNull Post post) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        Preconditions.checkNotNull(post, "post must not be null", new Object[0]);
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.allPosts.remove(post.getId());
            this.sonePosts.get(post.getSone().getId()).remove(post);
            post.getSone().removePost(post);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PostReply getPostReply(@NotNull String id) {
        PostReply postReply;
        Intrinsics.checkParameterIsNotNull(id, "id");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            postReply = this.allPostReplies.get(id);
        }
        finally {
            lock.unlock();
        }
        return postReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PostReply> getReplies(@NotNull String postId) {
        List<Reply<?>> list;
        Intrinsics.checkParameterIsNotNull(postId, "postId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            void $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = this.allPostReplies.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PostReply it = (PostReply)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getPostId(), postId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            Comparator<Reply<?>> comparator = ReplyKt.newestReplyFirst().reversed();
            Intrinsics.checkExpressionValueIsNotNull(comparator, "newestReplyFirst.reversed()");
            list = CollectionsKt.sortedWith(iterable2, comparator);
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    @Override
    @NotNull
    public PostReplyBuilder newPostReplyBuilder() {
        return new MemoryPostReplyBuilder(this, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePostReply(@NotNull PostReply postReply) {
        Intrinsics.checkParameterIsNotNull(postReply, "postReply");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            String string = postReply.getId();
            Intrinsics.checkExpressionValueIsNotNull(string, "postReply.id");
            this.allPostReplies.put(string, postReply);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePostReply(@NotNull PostReply postReply) {
        PostReply postReply2;
        Intrinsics.checkParameterIsNotNull(postReply, "postReply");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            postReply2 = this.allPostReplies.remove(postReply.getId());
        }
        finally {
            lock.unlock();
        }
        ObjectsKt.getUnit(postReply2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Album getAlbum(@NotNull String albumId) {
        Album album;
        Intrinsics.checkParameterIsNotNull(albumId, "albumId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            album = this.allAlbums.get(albumId);
        }
        finally {
            lock.unlock();
        }
        return album;
    }

    @Override
    @NotNull
    public AlbumBuilder newAlbumBuilder() {
        return new AlbumBuilderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAlbum(@NotNull Album album) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull(album, "album");
        Lock lock = this.getWriteLock();
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            String string = album.getId();
            Intrinsics.checkExpressionValueIsNotNull(string, "album.id");
            this.allAlbums.put(string, album);
            bl = this.soneAlbums.put(album.getSone().getId(), album);
        }
        finally {
            lock.unlock();
        }
        ObjectsKt.getUnit(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlbum(@NotNull Album album) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull(album, "album");
        Lock lock = this.getWriteLock();
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.allAlbums.remove(album.getId());
            bl = this.soneAlbums.remove(album.getSone().getId(), album);
        }
        finally {
            lock.unlock();
        }
        ObjectsKt.getUnit(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Image getImage(@NotNull String imageId) {
        Image image;
        Intrinsics.checkParameterIsNotNull(imageId, "imageId");
        Lock lock = this.getReadLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            image = this.allImages.get(imageId);
        }
        finally {
            lock.unlock();
        }
        return image;
    }

    @Override
    @NotNull
    public ImageBuilder newImageBuilder() {
        return new ImageBuilderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeImage(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull(image, "image");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            String string = image.getId();
            Intrinsics.checkExpressionValueIsNotNull(string, "image.id");
            this.allImages.put(string, image);
            this.soneImages.put(image.getSone().getId(), image);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImage(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull(image, "image");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.allImages.remove(image.getId());
            this.soneImages.remove(image.getSone().getId(), image);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void bookmarkPost(@NotNull Post post) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        this.memoryBookmarkDatabase.bookmarkPost(post);
    }

    @Override
    public void unbookmarkPost(@NotNull Post post) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        this.memoryBookmarkDatabase.unbookmarkPost(post);
    }

    @Override
    public boolean isPostBookmarked(@NotNull Post post) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        return this.memoryBookmarkDatabase.isPostBookmarked(post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isPostKnown(@NotNull Post post) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(post, "post");
        Lock lock = this.getReadLock();
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl = this.knownPosts.contains(post.getId());
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPostKnown(@NotNull Post post, boolean known) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (known) {
                String string = post.getId();
                Intrinsics.checkExpressionValueIsNotNull(string, "post.id");
                this.knownPosts.add(string);
            } else {
                this.knownPosts.remove(post.getId());
            }
            this.saveKnownPosts();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isPostReplyKnown(@NotNull PostReply postReply) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(postReply, "postReply");
        Lock lock = this.getReadLock();
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl = this.knownPostReplies.contains(postReply.getId());
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPostReplyKnown(@NotNull PostReply postReply) {
        Intrinsics.checkParameterIsNotNull(postReply, "postReply");
        Lock lock = this.getWriteLock();
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            String string = postReply.getId();
            Intrinsics.checkExpressionValueIsNotNull(string, "postReply.id");
            this.knownPostReplies.add(string);
            this.saveKnownPostReplies();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadKnownPosts() {
        boolean bl;
        Set<String> set = this.configurationLoader.loadKnownPosts();
        boolean bl2 = false;
        boolean bl3 = false;
        Set<String> it = set;
        boolean bl4 = false;
        Lock lock = this.getWriteLock();
        boolean bl5 = false;
        lock.lock();
        try {
            boolean bl6 = false;
            this.knownPosts.clear();
            Set<String> set2 = it;
            Intrinsics.checkExpressionValueIsNotNull(set2, "it");
            bl = this.knownPosts.addAll((Collection<String>)set2);
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    private final Unit saveKnownPosts() {
        return (Unit)BooleansKt.ifTrue(this.saveKnownPostsRateLimiter.tryAcquire(), (Function0)new Function0<Unit>(this){
            final /* synthetic */ MemoryDatabase this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    Lock lock = MemoryDatabase.access$getReadLock$p(this.this$0);
                    boolean bl = false;
                    lock.lock();
                    try {
                        boolean bl2 = false;
                        Iterable $this$forEachIndexed$iv = MemoryDatabase.access$getKnownPosts$p(this.this$0);
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            void knownPostId;
                            int n = index$iv++;
                            boolean bl3 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n2 = n;
                            String string = (String)item$iv;
                            int index = n2;
                            boolean bl4 = false;
                            Value<String> value = MemoryDatabase.access$getConfiguration$p(this.this$0).getStringValue("KnownPosts/" + index + "/ID");
                            Intrinsics.checkExpressionValueIsNotNull(value, "configuration.getStringV\u2026e(\"KnownPosts/$index/ID\")");
                            value.setValue((String)knownPostId);
                        }
                        Value<String> value = MemoryDatabase.access$getConfiguration$p(this.this$0).getStringValue("KnownPosts/" + MemoryDatabase.access$getKnownPosts$p(this.this$0).size() + "/ID");
                        Intrinsics.checkExpressionValueIsNotNull(value, "configuration.getStringV\u2026s/${knownPosts.size}/ID\")");
                        value.setValue(null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (ConfigurationException ce1) {
                    throw (Throwable)new DatabaseException("Could not save database.", ce1);
                }
            }
            {
                this.this$0 = memoryDatabase;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadKnownPostReplies() {
        Set<String> set = this.configurationLoader.loadKnownPostReplies();
        boolean bl = false;
        boolean bl2 = false;
        Set<String> knownPostReplies = set;
        boolean bl3 = false;
        Lock lock = this.getWriteLock();
        boolean bl4 = false;
        lock.lock();
        try {
            boolean bl5 = false;
            this.knownPostReplies.clear();
            Set<String> set2 = knownPostReplies;
            Intrinsics.checkExpressionValueIsNotNull(set2, "knownPostReplies");
            boolean bl6 = this.knownPostReplies.addAll((Collection<String>)set2);
        }
        finally {
            lock.unlock();
        }
    }

    private final Unit saveKnownPostReplies() {
        return (Unit)BooleansKt.ifTrue(this.saveKnownPostRepliesRateLimiter.tryAcquire(), (Function0)new Function0<Unit>(this){
            final /* synthetic */ MemoryDatabase this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    Lock lock = MemoryDatabase.access$getReadLock$p(this.this$0);
                    boolean bl = false;
                    lock.lock();
                    try {
                        boolean bl2 = false;
                        Iterable $this$forEachIndexed$iv = MemoryDatabase.access$getKnownPostReplies$p(this.this$0);
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            void knownPostReply;
                            int n = index$iv++;
                            boolean bl3 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n2 = n;
                            String string = (String)item$iv;
                            int index = n2;
                            boolean bl4 = false;
                            Value<String> value = MemoryDatabase.access$getConfiguration$p(this.this$0).getStringValue("KnownReplies/" + index + "/ID");
                            Intrinsics.checkExpressionValueIsNotNull(value, "configuration.getStringV\u2026\"KnownReplies/$index/ID\")");
                            value.setValue((String)knownPostReply);
                        }
                        Value<String> value = MemoryDatabase.access$getConfiguration$p(this.this$0).getStringValue("KnownReplies/" + MemoryDatabase.access$getKnownPostReplies$p(this.this$0).size() + "/ID");
                        Intrinsics.checkExpressionValueIsNotNull(value, "configuration.getStringV\u2026ownPostReplies.size}/ID\")");
                        value.setValue(null);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (ConfigurationException ce1) {
                    throw (Throwable)new DatabaseException("Could not save database.", ce1);
                }
            }
            {
                this.this$0 = memoryDatabase;
                super(0);
            }
        });
    }

    @Inject
    public MemoryDatabase(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.configuration = configuration;
        this.lock = new ReentrantReadWriteLock();
        this.readLock$delegate = LazyKt.lazy((Function0)new Function0<ReentrantReadWriteLock.ReadLock>(this){
            final /* synthetic */ MemoryDatabase this$0;

            @NotNull
            public final ReentrantReadWriteLock.ReadLock invoke() {
                ReentrantReadWriteLock.ReadLock readLock2 = MemoryDatabase.access$getLock$p(this.this$0).readLock();
                if (readLock2 == null) {
                    Intrinsics.throwNpe();
                }
                return readLock2;
            }
            {
                this.this$0 = memoryDatabase;
                super(0);
            }
        });
        this.writeLock$delegate = LazyKt.lazy((Function0)new Function0<ReentrantReadWriteLock.WriteLock>(this){
            final /* synthetic */ MemoryDatabase this$0;

            @NotNull
            public final ReentrantReadWriteLock.WriteLock invoke() {
                ReentrantReadWriteLock.WriteLock writeLock2 = MemoryDatabase.access$getLock$p(this.this$0).writeLock();
                if (writeLock2 == null) {
                    Intrinsics.throwNpe();
                }
                return writeLock2;
            }
            {
                this.this$0 = memoryDatabase;
                super(0);
            }
        });
        this.configurationLoader = new ConfigurationLoader(this.configuration);
        MemoryDatabase memoryDatabase = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        memoryDatabase.allSones = object;
        memoryDatabase = this;
        bl = false;
        object = new LinkedHashMap();
        memoryDatabase.allPosts = object;
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull(hashMultimap, "HashMultimap.create<String, Post>()");
        this.sonePosts = hashMultimap;
        memoryDatabase = this;
        bl = false;
        memoryDatabase.knownPosts = object = (Set)new LinkedHashSet();
        memoryDatabase = this;
        bl = false;
        memoryDatabase.allPostReplies = object = (Map)new LinkedHashMap();
        TreeMultimap treeMultimap = TreeMultimap.create(sonePostReplies.1.INSTANCE, ReplyKt.newestReplyFirst());
        Intrinsics.checkExpressionValueIsNotNull(treeMultimap, "TreeMultimap.create<Stri\u2026ing) }, newestReplyFirst)");
        this.sonePostReplies = treeMultimap;
        memoryDatabase = this;
        bl = false;
        memoryDatabase.knownPostReplies = object = (Set)new LinkedHashSet();
        memoryDatabase = this;
        bl = false;
        memoryDatabase.allAlbums = object = (Map)new LinkedHashMap();
        HashMultimap hashMultimap2 = HashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull(hashMultimap2, "HashMultimap.create<String, Album>()");
        this.soneAlbums = hashMultimap2;
        memoryDatabase = this;
        bl = false;
        memoryDatabase.allImages = object = (Map)new LinkedHashMap();
        HashMultimap hashMultimap3 = HashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull(hashMultimap3, "HashMultimap.create<String, Image>()");
        this.soneImages = hashMultimap3;
        this.memoryBookmarkDatabase = new MemoryBookmarkDatabase(this, this.configurationLoader);
        this.memoryFriendDatabase = new MemoryFriendDatabase(this.configurationLoader);
        RateLimiter rateLimiter = RateLimiter.create(1.0);
        Intrinsics.checkExpressionValueIsNotNull(rateLimiter, "RateLimiter.create(1.0)");
        this.saveRateLimiter = rateLimiter;
        RateLimiter rateLimiter2 = RateLimiter.create(1.0);
        Intrinsics.checkExpressionValueIsNotNull(rateLimiter2, "RateLimiter.create(1.0)");
        this.saveKnownPostsRateLimiter = rateLimiter2;
        RateLimiter rateLimiter3 = RateLimiter.create(1.0);
        Intrinsics.checkExpressionValueIsNotNull(rateLimiter3, "RateLimiter.create(1.0)");
        this.saveKnownPostRepliesRateLimiter = rateLimiter3;
    }

    public static final /* synthetic */ ReentrantReadWriteLock.ReadLock access$getReadLock$p(MemoryDatabase $this) {
        return $this.getReadLock();
    }

    public static final /* synthetic */ Set access$getKnownPosts$p(MemoryDatabase $this) {
        return $this.knownPosts;
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(MemoryDatabase $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ Set access$getKnownPostReplies$p(MemoryDatabase $this) {
        return $this.knownPostReplies;
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(MemoryDatabase $this) {
        return $this.lock;
    }
}

