/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.database.memory;

import com.google.common.base.Optional;
import java.util.UUID;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.SoneProvider;
import net.pterodactylus.sone.database.memory.MemoryDatabase;

class MemoryPost
implements Post {
    private final MemoryDatabase postDatabase;
    private final SoneProvider soneProvider;
    private final UUID id;
    private final String soneId;
    private final String recipientId;
    private final long time;
    private final String text;

    public MemoryPost(MemoryDatabase postDatabase, SoneProvider soneProvider, String id, String soneId2, String recipientId, long time, String text) {
        this.postDatabase = postDatabase;
        this.soneProvider = soneProvider;
        this.id = UUID.fromString(id);
        this.soneId = soneId2;
        this.recipientId = recipientId;
        this.time = time;
        this.text = text;
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public Sone getSone() {
        return this.soneProvider.getSone(this.soneId);
    }

    @Override
    public Optional<String> getRecipientId() {
        return Optional.fromNullable(this.recipientId);
    }

    @Override
    public Optional<Sone> getRecipient() {
        return this.recipientId == null ? Optional.absent() : Optional.fromNullable(this.soneProvider.getSone(this.recipientId));
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isKnown() {
        return this.postDatabase.isPostKnown(this);
    }

    @Override
    public MemoryPost setKnown(boolean known) {
        this.postDatabase.setPostKnown(this, known);
        return this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemoryPost)) {
            return false;
        }
        MemoryPost post = (MemoryPost)object;
        return post.id.equals(this.id);
    }

    public String toString() {
        return String.format("%s[id=%s,sone=%s,recipient=%s,time=%d,text=%s]", this.getClass().getName(), this.id, this.soneId, this.recipientId, this.time, this.text);
    }
}

