/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.fcp;

import com.google.common.base.Optional;
import freenet.node.FSParseException;
import freenet.support.SimpleFieldSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.fcp.AbstractSoneCommandKt;
import net.pterodactylus.sone.freenet.SimpleFieldSetBuilder;
import net.pterodactylus.sone.freenet.fcp.AbstractCommand;
import net.pterodactylus.sone.freenet.fcp.FcpException;
import net.pterodactylus.sone.utils.ObjectsKt;
import net.pterodactylus.sone.utils.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0004J&\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0004J\u001e\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0014\u0010\u0018\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0004J\u0014\u0010\u001a\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0004J\u001c\u0010\u001b\u001a\u00020\u001c*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0004J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006 "}, d2={"Lnet/pterodactylus/sone/fcp/AbstractSoneCommand;", "Lnet/pterodactylus/sone/freenet/fcp/AbstractCommand;", "core", "Lnet/pterodactylus/sone/core/Core;", "requiresWriteAccess", "", "(Lnet/pterodactylus/sone/core/Core;Z)V", "getCore", "()Lnet/pterodactylus/sone/core/Core;", "()Z", "encodePost", "Lfreenet/support/SimpleFieldSet;", "post", "Lnet/pterodactylus/sone/data/Post;", "prefix", "", "includeReplies", "encodePosts", "posts", "", "encodeReplies", "replies", "Lnet/pterodactylus/sone/data/PostReply;", "toString", "getPost", "parameterName", "getReply", "getSone", "Lnet/pterodactylus/sone/data/Sone;", "localOnly", "Lcom/google/common/base/Optional;", "mandatory", "Sone"})
public abstract class AbstractSoneCommand
extends AbstractCommand {
    @NotNull
    private final Core core;
    private final boolean requiresWriteAccess;

    @NotNull
    protected final Sone getSone(@NotNull SimpleFieldSet $this$getSone, @NotNull String parameterName, boolean localOnly) throws FcpException {
        Intrinsics.checkParameterIsNotNull($this$getSone, "$this$getSone");
        Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
        Sone sone = this.getSone($this$getSone, parameterName, localOnly, true).get();
        Intrinsics.checkExpressionValueIsNotNull(sone, "getSone(parameterName, localOnly, true).get()");
        return sone;
    }

    @NotNull
    protected final Optional<Sone> getSone(@NotNull SimpleFieldSet $this$getSone, @NotNull String parameterName, boolean localOnly, boolean mandatory) throws FcpException {
        Intrinsics.checkParameterIsNotNull($this$getSone, "$this$getSone");
        Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
        String string = ObjectsKt.throwOnNullIf($this$getSone.get(parameterName), mandatory, (Function0<? extends Throwable>)new Function0<FcpException>(parameterName){
            final /* synthetic */ String $parameterName;

            @NotNull
            public final FcpException invoke() {
                return new FcpException("Could not load Sone ID from \u201c" + this.$parameterName + "\u201d.");
            }
            {
                this.$parameterName = string;
                super(0);
            }
        });
        if (string == null) {
            Optional<Sone> optional = Optional.absent();
            Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.absent()");
            return optional;
        }
        String soneId2 = string;
        Sone sone = this.core.getSone(soneId2);
        if (mandatory && sone == null || sone != null && localOnly && !sone.isLocal()) {
            throw (Throwable)new FcpException("Could not load Sone from \u201c" + soneId2 + "\u201d.");
        }
        return OptionalsKt.asOptional(sone);
    }

    @NotNull
    protected final Post getPost(@NotNull SimpleFieldSet $this$getPost, @NotNull String parameterName) throws FcpException {
        Intrinsics.checkParameterIsNotNull($this$getPost, "$this$getPost");
        Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
        try {
            String postId = $this$getPost.getString(parameterName);
            Post post = this.core.getPost(postId);
            if (post == null) {
                throw (Throwable)new FcpException("Could not load post from \u201c" + postId + "\u201d.");
            }
            return post;
        }
        catch (FSParseException fspe1) {
            throw (Throwable)new FcpException("Could not post ID from \u201c" + parameterName + "\u201d.", fspe1);
        }
    }

    @NotNull
    protected final PostReply getReply(@NotNull SimpleFieldSet $this$getReply, @NotNull String parameterName) throws FcpException {
        Intrinsics.checkParameterIsNotNull($this$getReply, "$this$getReply");
        Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
        try {
            String replyId = $this$getReply.getString(parameterName);
            PostReply postReply = this.core.getPostReply(replyId);
            if (postReply == null) {
                throw (Throwable)new FcpException("Could not load reply from \u201c" + replyId + "\u201d.");
            }
            return postReply;
        }
        catch (FSParseException fspe1) {
            throw (Throwable)new FcpException("Could not reply ID from \u201c" + parameterName + "\u201d.", fspe1);
        }
    }

    @NotNull
    protected final SimpleFieldSet encodePost(@NotNull Post post, @NotNull String prefix, boolean includeReplies) {
        Intrinsics.checkParameterIsNotNull(post, "post");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        SimpleFieldSetBuilder simpleFieldSetBuilder = new SimpleFieldSetBuilder();
        boolean bl = false;
        boolean bl2 = false;
        SimpleFieldSetBuilder $this$apply = simpleFieldSetBuilder;
        boolean bl3 = false;
        $this$apply.put(prefix + "ID", post.getId());
        $this$apply.put(prefix + "Sone", post.getSone().getId());
        Optional<String> optional = post.getRecipientId();
        Intrinsics.checkExpressionValueIsNotNull(optional, "post.recipientId");
        OptionalsKt.let(optional, (Function1)new Function1<String, SimpleFieldSetBuilder>($this$apply, this, prefix, post, includeReplies){
            final /* synthetic */ SimpleFieldSetBuilder $this_apply;
            final /* synthetic */ AbstractSoneCommand this$0;
            final /* synthetic */ String $prefix$inlined;
            final /* synthetic */ Post $post$inlined;
            final /* synthetic */ boolean $includeReplies$inlined;
            {
                this.$this_apply = simpleFieldSetBuilder;
                this.this$0 = abstractSoneCommand;
                this.$prefix$inlined = string;
                this.$post$inlined = post;
                this.$includeReplies$inlined = bl;
                super(1);
            }

            public final SimpleFieldSetBuilder invoke(String it) {
                return this.$this_apply.put(this.$prefix$inlined + "Recipient", it);
            }
        });
        $this$apply.put(prefix + "Time", post.getTime());
        String string = prefix + "Text";
        String string2 = post.getText();
        Intrinsics.checkExpressionValueIsNotNull(string2, "post.text");
        $this$apply.put(string, AbstractSoneCommandKt.encodeString(string2));
        Set<Sone> set = this.core.getLikes(post);
        Intrinsics.checkExpressionValueIsNotNull(set, "core.getLikes(post)");
        $this$apply.put(AbstractSoneCommandKt.encodeLikes((Collection<? extends Sone>)set, prefix + "Likes."));
        if (includeReplies) {
            List<PostReply> list = this.core.getReplies(post.getId());
            Intrinsics.checkExpressionValueIsNotNull(list, "core.getReplies(post.id)");
            List<PostReply> replies = list;
            $this$apply.put(this.encodeReplies((Collection<? extends PostReply>)replies, prefix));
        }
        SimpleFieldSet simpleFieldSet = simpleFieldSetBuilder.get();
        Intrinsics.checkExpressionValueIsNotNull(simpleFieldSet, "SimpleFieldSetBuilder().\u2026es, prefix))\n\t\t}\n\t}.get()");
        return simpleFieldSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final SimpleFieldSet encodePosts(@NotNull Collection<? extends Post> posts, @NotNull String prefix, boolean includeReplies) {
        Intrinsics.checkParameterIsNotNull(posts, "posts");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        SimpleFieldSetBuilder simpleFieldSetBuilder = new SimpleFieldSetBuilder();
        boolean bl = false;
        boolean bl2 = false;
        SimpleFieldSetBuilder $this$apply = simpleFieldSetBuilder;
        boolean bl3 = false;
        $this$apply.put(prefix + "Count", posts.size());
        Iterable $this$forEachIndexed$iv = posts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void post;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Post post2 = (Post)item$iv;
            int postIndex = n2;
            boolean bl5 = false;
            $this$apply.put(this.encodePost((Post)post, prefix + postIndex + '.', includeReplies));
        }
        SimpleFieldSet simpleFieldSet = simpleFieldSetBuilder.get();
        Intrinsics.checkExpressionValueIsNotNull(simpleFieldSet, "SimpleFieldSetBuilder().\u2026udeReplies))\n\t\t}\n\t}.get()");
        return simpleFieldSet;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFieldSet encodeReplies(Collection<? extends PostReply> replies, String prefix) {
        SimpleFieldSetBuilder simpleFieldSetBuilder = new SimpleFieldSetBuilder();
        boolean bl = false;
        boolean bl2 = false;
        SimpleFieldSetBuilder $this$apply = simpleFieldSetBuilder;
        boolean bl3 = false;
        $this$apply.put(prefix + "Replies.Count", replies.size());
        Iterable $this$forEachIndexed$iv = replies;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void reply;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PostReply postReply = (PostReply)item$iv;
            int replyIndex = n2;
            boolean bl5 = false;
            String replyPrefix = prefix + "Replies." + replyIndex + '.';
            $this$apply.put(replyPrefix + "ID", reply.getId());
            $this$apply.put(replyPrefix + "Sone", reply.getSone().getId());
            $this$apply.put(replyPrefix + "Time", reply.getTime());
            String string = replyPrefix + "Text";
            String string2 = reply.getText();
            Intrinsics.checkExpressionValueIsNotNull(string2, "reply.text");
            $this$apply.put(string, AbstractSoneCommandKt.encodeString(string2));
            Set<Sone> set = this.core.getLikes((PostReply)reply);
            Intrinsics.checkExpressionValueIsNotNull(set, "core.getLikes(reply)");
            $this$apply.put(AbstractSoneCommandKt.encodeLikes((Collection<? extends Sone>)set, replyPrefix + "Likes."));
        }
        SimpleFieldSet simpleFieldSet = simpleFieldSetBuilder.get();
        Intrinsics.checkExpressionValueIsNotNull(simpleFieldSet, "SimpleFieldSetBuilder().\u2026ix}Likes.\"))\n\t\t}\n\t}.get()");
        return simpleFieldSet;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + "[requiresWriteAccess=" + this.requiresWriteAccess + ']';
    }

    @NotNull
    protected final Core getCore() {
        return this.core;
    }

    @JvmName(name="requiresWriteAccess")
    public final boolean requiresWriteAccess() {
        return this.requiresWriteAccess;
    }

    @JvmOverloads
    protected AbstractSoneCommand(@NotNull Core core, boolean requiresWriteAccess) {
        Intrinsics.checkParameterIsNotNull(core, "core");
        this.core = core;
        this.requiresWriteAccess = requiresWriteAccess;
    }

    public /* synthetic */ AbstractSoneCommand(Core core, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(core, bl);
    }

    @JvmOverloads
    protected AbstractSoneCommand(@NotNull Core core) {
        this(core, false, 2, null);
    }
}

