/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.fcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginReplySender;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.fcp.AbstractSoneCommand;
import net.pterodactylus.sone.fcp.CreatePostCommand;
import net.pterodactylus.sone.fcp.CreateReplyCommand;
import net.pterodactylus.sone.fcp.DeletePostCommand;
import net.pterodactylus.sone.fcp.DeleteReplyCommand;
import net.pterodactylus.sone.fcp.GetLocalSonesCommand;
import net.pterodactylus.sone.fcp.GetPostCommand;
import net.pterodactylus.sone.fcp.GetPostFeedCommand;
import net.pterodactylus.sone.fcp.GetPostsCommand;
import net.pterodactylus.sone.fcp.GetSoneCommand;
import net.pterodactylus.sone.fcp.GetSonesCommand;
import net.pterodactylus.sone.fcp.LikePostCommand;
import net.pterodactylus.sone.fcp.LikeReplyCommand;
import net.pterodactylus.sone.fcp.LockSoneCommand;
import net.pterodactylus.sone.fcp.UnlockSoneCommand;
import net.pterodactylus.sone.fcp.VersionCommand;
import net.pterodactylus.sone.fcp.event.FcpInterfaceActivatedEvent;
import net.pterodactylus.sone.fcp.event.FcpInterfaceDeactivatedEvent;
import net.pterodactylus.sone.fcp.event.FullAccessRequiredChanged;
import net.pterodactylus.sone.freenet.fcp.Command;

@Singleton
public class FcpInterface {
    private static final Logger logger = Logger.getLogger(FcpInterface.class.getName());
    private final AtomicBoolean active = new AtomicBoolean();
    private final AtomicReference<FullAccessRequired> fullAccessRequired = new AtomicReference<FullAccessRequired>(FullAccessRequired.ALWAYS);
    private final Map<String, AbstractSoneCommand> commands;
    private final AccessAuthorizer accessAuthorizer;

    @Inject
    public FcpInterface(Core core, CommandSupplier commandSupplier, AccessAuthorizer accessAuthorizer) {
        this.commands = commandSupplier.supplyCommands(core);
        this.accessAuthorizer = accessAuthorizer;
    }

    @VisibleForTesting
    boolean isActive() {
        return this.active.get();
    }

    private void setActive(boolean active) {
        this.active.set(active);
    }

    @VisibleForTesting
    FullAccessRequired getFullAccessRequired() {
        return this.fullAccessRequired.get();
    }

    private void setFullAccessRequired(FullAccessRequired fullAccessRequired) {
        this.fullAccessRequired.set(Preconditions.checkNotNull(fullAccessRequired, "fullAccessRequired must not be null"));
    }

    public void handle(PluginReplySender pluginReplySender, SimpleFieldSet parameters2, Bucket data, int accessType) {
        String identifier = parameters2.get("Identifier");
        if (identifier == null || identifier.length() == 0) {
            this.sendErrorReply(pluginReplySender, null, 400, "Missing Identifier.");
            return;
        }
        if (!this.active.get()) {
            this.sendErrorReply(pluginReplySender, identifier, 503, "FCP Interface deactivated");
            return;
        }
        AbstractSoneCommand command = this.commands.get(parameters2.get("Message"));
        if (command == null) {
            this.sendErrorReply(pluginReplySender, identifier, 404, "Unrecognized Message: " + parameters2.get("Message"));
            return;
        }
        if (!this.accessAuthorizer.authorized(Command.AccessType.values()[accessType], this.fullAccessRequired.get(), command.requiresWriteAccess())) {
            this.sendErrorReply(pluginReplySender, identifier, 401, "Not authorized");
            return;
        }
        try {
            Command.Response response = command.execute(parameters2);
            FcpInterface.sendReply(pluginReplySender, identifier, response);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Could not process FCP command \u201c%s\u201d.", command);
            this.sendErrorReply(pluginReplySender, identifier, 500, "Error executing command: " + e1.getMessage());
        }
    }

    private void sendErrorReply(PluginReplySender pluginReplySender, String identifier, int errorCode, String message) {
        try {
            FcpInterface.sendReply(pluginReplySender, identifier, new Command.ErrorResponse(errorCode, message));
        }
        catch (PluginNotFoundException pnfe1) {
            logger.log(Level.FINE, "Could not send error to plugin.", pnfe1);
        }
    }

    private static void sendReply(PluginReplySender pluginReplySender, String identifier, Command.Response response) throws PluginNotFoundException {
        SimpleFieldSet replyParameters = response.getReplyParameters();
        if (identifier != null) {
            replyParameters.putOverwrite("Identifier", identifier);
        }
        pluginReplySender.send(replyParameters);
    }

    @Subscribe
    public void fcpInterfaceActivated(FcpInterfaceActivatedEvent fcpInterfaceActivatedEvent) {
        this.setActive(true);
    }

    @Subscribe
    public void fcpInterfaceDeactivated(FcpInterfaceDeactivatedEvent fcpInterfaceDeactivatedEvent) {
        this.setActive(false);
    }

    @Subscribe
    public void fullAccessRequiredChanged(FullAccessRequiredChanged fullAccessRequiredChanged) {
        this.setFullAccessRequired(fullAccessRequiredChanged.getFullAccessRequired());
    }

    @Singleton
    public static class AccessAuthorizer {
        public boolean authorized(@Nonnull Command.AccessType accessType, @Nonnull FullAccessRequired fullAccessRequired, boolean commandRequiresWriteAccess) {
            return accessType != Command.AccessType.RESTRICTED_FCP || fullAccessRequired == FullAccessRequired.NO || fullAccessRequired == FullAccessRequired.WRITING && !commandRequiresWriteAccess;
        }
    }

    @Singleton
    public static class CommandSupplier {
        public Map<String, AbstractSoneCommand> supplyCommands(Core core) {
            HashMap<String, AbstractSoneCommand> commands = new HashMap<String, AbstractSoneCommand>();
            commands.put("Version", new VersionCommand(core));
            commands.put("GetLocalSones", new GetLocalSonesCommand(core));
            commands.put("GetSones", new GetSonesCommand(core));
            commands.put("GetSone", new GetSoneCommand(core));
            commands.put("GetPost", new GetPostCommand(core));
            commands.put("GetPosts", new GetPostsCommand(core));
            commands.put("GetPostFeed", new GetPostFeedCommand(core));
            commands.put("LockSone", new LockSoneCommand(core));
            commands.put("UnlockSone", new UnlockSoneCommand(core));
            commands.put("LikePost", new LikePostCommand(core));
            commands.put("LikeReply", new LikeReplyCommand(core));
            commands.put("CreatePost", new CreatePostCommand(core));
            commands.put("CreateReply", new CreateReplyCommand(core));
            commands.put("DeletePost", new DeletePostCommand(core));
            commands.put("DeleteReply", new DeleteReplyCommand(core));
            return commands;
        }
    }

    public static enum FullAccessRequired {
        NO,
        WRITING,
        ALWAYS;

    }
}

