/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.fcp;

import com.google.common.collect.Collections2;
import freenet.support.SimpleFieldSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.fcp.AbstractSoneCommand;
import net.pterodactylus.sone.freenet.fcp.Command;
import net.pterodactylus.sone.freenet.fcp.FcpException;

public class GetPostFeedCommand
extends AbstractSoneCommand {
    public GetPostFeedCommand(Core core) {
        super(core);
    }

    @Override
    public Command.Response execute(SimpleFieldSet parameters2) throws FcpException {
        Sone sone = this.getSone(parameters2, "Sone", true);
        int startPost = GetPostFeedCommand.getInt(parameters2, "StartPost", 0);
        int maxPosts = GetPostFeedCommand.getInt(parameters2, "MaxPosts", -1);
        Collection<Post> allPosts = new HashSet<Post>();
        allPosts.addAll(sone.getPosts());
        for (String friendSoneId : sone.getFriends()) {
            Sone friendSone = this.getCore().getSone(friendSoneId);
            if (friendSone == null) continue;
            allPosts.addAll(friendSone.getPosts());
        }
        allPosts.addAll(this.getCore().getDirectedPosts(sone.getId()));
        allPosts = Collections2.filter(allPosts, PostKt.noFuturePost()::invoke);
        ArrayList<Post> sortedPosts = new ArrayList<Post>(allPosts);
        sortedPosts.sort(PostKt.newestPostFirst());
        if (sortedPosts.size() < startPost) {
            return new Command.Response("PostFeed", this.encodePosts(Collections.emptyList(), "Posts.", false));
        }
        return new Command.Response("PostFeed", this.encodePosts(sortedPosts.subList(startPost, maxPosts == -1 ? sortedPosts.size() : Math.min(startPost + maxPosts, sortedPosts.size())), "Posts.", true));
    }
}

