/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.freenet;

import freenet.client.async.PersistenceDisabledException;
import freenet.pluginmanager.PluginRespirator;
import freenet.pluginmanager.PluginStore;
import java.util.logging.Logger;
import net.pterodactylus.util.config.AttributeNotFoundException;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.ExtendedConfigurationBackend;

public class PluginStoreConfigurationBackend
implements ExtendedConfigurationBackend {
    private static final Logger logger = Logger.getLogger(PluginStoreConfigurationBackend.class.getName());
    private final PluginRespirator pluginRespirator;
    private final PluginStore pluginStore;

    public PluginStoreConfigurationBackend(PluginRespirator pluginRespirator) throws PersistenceDisabledException {
        this.pluginRespirator = pluginRespirator;
        this.pluginStore = pluginRespirator.getStore();
    }

    @Override
    public String getValue(String attribute) throws ConfigurationException {
        if (!this.pluginStore.strings.containsKey(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        return (String)this.pluginStore.strings.get(attribute);
    }

    @Override
    public void putValue(String attribute, String value) throws ConfigurationException {
        this.pluginStore.strings.put(attribute, value);
        this.save();
    }

    @Override
    public Boolean getBooleanValue(String attribute) throws ConfigurationException {
        if (!this.pluginStore.booleans.containsKey(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        return (Boolean)this.pluginStore.booleans.get(attribute);
    }

    @Override
    public void setBooleanValue(String attribute, Boolean value) throws ConfigurationException {
        this.pluginStore.booleans.put(attribute, value);
        this.save();
    }

    @Override
    public Double getDoubleValue(String attribute) throws ConfigurationException {
        if (!this.pluginStore.strings.containsKey(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        String stringValue = (String)this.pluginStore.strings.get(attribute);
        if (stringValue == null) {
            return null;
        }
        try {
            return Double.valueOf((String)this.pluginStore.strings.get(attribute));
        }
        catch (NumberFormatException nfe1) {
            throw new ConfigurationException("Could not parse \u201c" + stringValue + "\u201d.", nfe1);
        }
    }

    @Override
    public void setDoubleValue(String attribute, Double value) throws ConfigurationException {
        this.pluginStore.strings.put(attribute, String.valueOf(value));
        this.save();
    }

    @Override
    public Integer getIntegerValue(String attribute) throws ConfigurationException {
        if (!this.pluginStore.integers.containsKey(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        return (Integer)this.pluginStore.integers.get(attribute);
    }

    @Override
    public void setIntegerValue(String attribute, Integer value) throws ConfigurationException {
        this.pluginStore.integers.put(attribute, value);
        this.save();
    }

    @Override
    public Long getLongValue(String attribute) throws ConfigurationException {
        if (!this.pluginStore.longs.containsKey(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        return (Long)this.pluginStore.longs.get(attribute);
    }

    @Override
    public void setLongValue(String attribute, Long value) throws ConfigurationException {
        this.pluginStore.longs.put(attribute, value);
        this.save();
    }

    @Override
    public void save() throws ConfigurationException {
        try {
            this.pluginRespirator.putStore(this.pluginStore);
        }
        catch (PersistenceDisabledException pde1) {
            throw new ConfigurationException("Could not store plugin store, persistence is disabled.", pde1);
        }
    }
}

