/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.freenet.fcp;

import freenet.support.SimpleFieldSet;
import net.pterodactylus.sone.freenet.SimpleFieldSetBuilder;
import net.pterodactylus.sone.freenet.fcp.FcpException;

public interface Command {
    public Response execute(SimpleFieldSet var1) throws FcpException;

    public static class ErrorResponse
    extends Response {
        public ErrorResponse(String message) {
            super("Error", new SimpleFieldSetBuilder().put("ErrorMessage", message).get());
        }

        public ErrorResponse(int code, String message) {
            super("Error", new SimpleFieldSetBuilder().put("ErrorMessage", message).put("ErrorCode", code).get());
        }
    }

    public static class Response {
        private final String messageName;
        private final SimpleFieldSet replyParameters;

        public Response(String messageName, SimpleFieldSet replyParameters) {
            this.messageName = messageName;
            this.replyParameters = replyParameters;
        }

        public SimpleFieldSet getReplyParameters() {
            return new SimpleFieldSetBuilder(this.replyParameters).put("Message", this.messageName).get();
        }
    }

    public static enum AccessType {
        DIRECT,
        RESTRICTED_FCP,
        FULL_FCP;

    }
}

