/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.freenet.wot;

import com.google.common.eventbus.EventBus;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.WebOfTrustAppeared;
import net.pterodactylus.sone.core.event.WebOfTrustDisappeared;
import net.pterodactylus.sone.freenet.plugin.PluginException;
import net.pterodactylus.sone.utils.FunctionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0001\u0012\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/pterodactylus/sone/freenet/wot/WebOfTrustPinger;", "Ljava/lang/Runnable;", "eventBus", "Lcom/google/common/eventbus/EventBus;", "webOfTrustReacher", "reschedule", "Ljava/util/function/Consumer;", "(Lcom/google/common/eventbus/EventBus;Ljava/lang/Runnable;Ljava/util/function/Consumer;)V", "lastState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "run", "", "Sone"})
public final class WebOfTrustPinger
implements Runnable {
    private final AtomicBoolean lastState;
    private final EventBus eventBus;
    private final Runnable webOfTrustReacher;
    private final Consumer<Runnable> reschedule;

    @Override
    public void run() {
        block3: {
            try {
                FunctionsKt.invoke(this.webOfTrustReacher);
                if (!this.lastState.get()) {
                    this.eventBus.post(new WebOfTrustAppeared());
                    this.lastState.set(true);
                }
            }
            catch (PluginException e) {
                if (!this.lastState.get()) break block3;
                this.eventBus.post(new WebOfTrustDisappeared());
                this.lastState.set(false);
            }
        }
        FunctionsKt.invoke(this.reschedule, this);
    }

    @Inject
    public WebOfTrustPinger(@NotNull EventBus eventBus, @Named(value="webOfTrustReacher") @NotNull Runnable webOfTrustReacher, @Named(value="webOfTrustReschedule") @NotNull Consumer<Runnable> reschedule) {
        Intrinsics.checkParameterIsNotNull(eventBus, "eventBus");
        Intrinsics.checkParameterIsNotNull(webOfTrustReacher, "webOfTrustReacher");
        Intrinsics.checkParameterIsNotNull(reschedule, "reschedule");
        this.eventBus = eventBus;
        this.webOfTrustReacher = webOfTrustReacher;
        this.reschedule = reschedule;
        this.lastState = new AtomicBoolean(false);
    }
}

