/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.main;

import java.io.File;
import javax.annotation.Nonnull;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.template.FilesystemTemplate;
import net.pterodactylus.sone.web.pages.ReloadingPage;
import net.pterodactylus.util.template.FilesystemTemplateProvider;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateProvider;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.Request;

public class DebugLoaders
implements Loaders {
    private final String filesystemPath;

    public DebugLoaders(String filesystemPath) {
        this.filesystemPath = filesystemPath;
    }

    @Override
    @Nonnull
    public Template loadTemplate(@Nonnull String path) {
        return new FilesystemTemplate(new File(this.filesystemPath, path).getAbsolutePath());
    }

    @Override
    @Nonnull
    public <REQ extends Request> Page<REQ> loadStaticPage(@Nonnull String basePath, @Nonnull String prefix, @Nonnull String mimeType) {
        return new ReloadingPage(basePath, new File(this.filesystemPath, prefix).getAbsolutePath(), mimeType);
    }

    @Override
    @Nonnull
    public TemplateProvider getTemplateProvider() {
        return new FilesystemTemplateProvider(new File(this.filesystemPath, "/templates/").getAbsolutePath());
    }
}

