/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.notify;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.sone.freenet.wot.Trust;

@Singleton
public class PostVisibilityFilter {
    boolean isPostVisible(@Nullable Sone sone, @Nonnull Post post) {
        Preconditions.checkNotNull(post, "post must not be null");
        if (!post.isLoaded()) {
            return false;
        }
        Sone postSone = post.getSone();
        if (sone != null) {
            Trust trust = postSone.getIdentity().getTrust((OwnIdentity)sone.getIdentity());
            if (trust != null) {
                if (trust.getExplicit() != null && trust.getExplicit() < 0) {
                    return false;
                }
                if (trust.getExplicit() == null && trust.getImplicit() != null && trust.getImplicit() < 0) {
                    return false;
                }
            }
            if (!(postSone.equals(sone) || sone.hasFriend(postSone.getId()) || sone.getId().equals(post.getRecipientId().orNull()))) {
                return false;
            }
        }
        return post.getTime() <= System.currentTimeMillis();
    }

    @Nonnull
    public Predicate<Post> isVisible(final @Nullable Sone currentSone) {
        return new Predicate<Post>(){

            @Override
            public boolean apply(@Nullable Post post) {
                return post != null && PostVisibilityFilter.this.isPostVisible(currentSone, post);
            }
        };
    }
}

