/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.notify;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.notify.PostVisibilityFilter;

@Singleton
public class ReplyVisibilityFilter {
    private final PostVisibilityFilter postVisibilityFilter;

    @Inject
    public ReplyVisibilityFilter(@Nonnull PostVisibilityFilter postVisibilityFilter) {
        this.postVisibilityFilter = postVisibilityFilter;
    }

    boolean isReplyVisible(@Nullable Sone sone, @Nonnull PostReply reply) {
        Preconditions.checkNotNull(reply, "reply must not be null");
        Optional<Post> post = reply.getPost();
        if (!post.isPresent()) {
            return false;
        }
        if (!this.postVisibilityFilter.isPostVisible(sone, post.get())) {
            return false;
        }
        return reply.getTime() <= System.currentTimeMillis();
    }

    @Nonnull
    public Predicate<PostReply> isVisible(final @Nullable Sone currentSone) {
        return new Predicate<PostReply>(){

            @Override
            public boolean apply(@Nullable PostReply postReply) {
                return postReply != null && ReplyVisibilityFilter.this.isReplyVisible(currentSone, postReply);
            }
        };
    }
}

