/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.pterodactylus.util.template.Part;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;

public class FilesystemTemplate
extends Template {
    private final String filename;
    private final AtomicReference<LastLoadedTemplate> lastTemplate = new AtomicReference();
    private final TemplateContext initialContext = new TemplateContext();
    private final List<Part> parts = new ArrayList<Part>();

    public FilesystemTemplate(String filename) {
        this.filename = filename;
    }

    @Override
    public TemplateContext getInitialContext() {
        this.loadTemplate();
        return this.initialContext;
    }

    private void loadTemplate() {
        File templateFile = new File(this.filename);
        if (this.templateWasLoaded() && !this.templateFileHasBeenModifiedAfterLoading(templateFile)) {
            return;
        }
        try (FileInputStream templateInputStream = new FileInputStream(templateFile);
             InputStreamReader templateReader = new InputStreamReader((InputStream)templateInputStream, Charsets.UTF_8);){
            Template template = TemplateParser.parse(templateReader);
            this.lastTemplate.set(new LastLoadedTemplate(template));
            template.getInitialContext().mergeContext(this.initialContext);
            for (Part part : this.parts) {
                template.add(part);
            }
        }
        catch (IOException e) {
            throw new TemplateFileNotFoundException(this.filename);
        }
    }

    private boolean templateWasLoaded() {
        return this.lastTemplate.get() != null;
    }

    private boolean templateFileHasBeenModifiedAfterLoading(File templateFile) {
        return templateFile.lastModified() > this.lastTemplate.get().getLoadTime();
    }

    @Override
    public void add(Part part) {
        this.loadTemplate();
        this.parts.add(part);
        this.lastTemplate.get().getTemplate().add(part);
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        this.loadTemplate();
        this.lastTemplate.get().getTemplate().render(templateContext, writer);
    }

    @Override
    public Iterator<Part> iterator() {
        this.loadTemplate();
        return this.lastTemplate.get().getTemplate().iterator();
    }

    @Override
    public int getLine() {
        this.loadTemplate();
        return this.lastTemplate.get().getTemplate().getLine();
    }

    @Override
    public int getColumn() {
        this.loadTemplate();
        return this.lastTemplate.get().getTemplate().getColumn();
    }

    public static class TemplateFileNotFoundException
    extends RuntimeException {
        public TemplateFileNotFoundException(String filename) {
            super(filename);
        }
    }

    private static class LastLoadedTemplate {
        private final Template template;
        private final long loadTime = System.currentTimeMillis();

        private LastLoadedTemplate(Template template) {
            this.template = template;
        }

        public Template getTemplate() {
            return this.template;
        }

        public long getLoadTime() {
            return this.loadTime;
        }
    }
}

