/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.freenet.wot.Identity;
import net.pterodactylus.sone.freenet.wot.OwnIdentity;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;

@Singleton
public class IdentityAccessor
extends ReflectionAccessor {
    private final Core core;

    @Inject
    public IdentityAccessor(Core core) {
        this.core = core;
    }

    @Override
    public Object get(TemplateContext templateContext, Object object, String member) {
        Identity identity = (Identity)object;
        if ("uniqueNickname".equals(member)) {
            boolean unique;
            boolean found;
            int minLength = -1;
            Set<OwnIdentity> ownIdentities = this.core.getIdentityManager().getAllOwnIdentities();
            block0: do {
                unique = true;
                String abbreviatedWantedNickname = IdentityAccessor.getAbbreviatedNickname(identity, ++minLength);
                for (Identity identity2 : ownIdentities) {
                    String abbreviatedNickname;
                    if (identity2.equals(identity) || !(abbreviatedNickname = IdentityAccessor.getAbbreviatedNickname(identity2, minLength)).equals(abbreviatedWantedNickname)) continue;
                    unique = false;
                    continue block0;
                }
            } while (!(found = unique) && minLength < 43);
            return IdentityAccessor.getAbbreviatedNickname(identity, minLength);
        }
        return super.get(templateContext, object, member);
    }

    private static String getAbbreviatedNickname(Identity identity, int length) {
        return identity.getNickname() + (length > 0 ? "@" + identity.getId().substring(0, length) : "");
    }
}

