/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import com.google.common.io.BaseEncoding;
import java.util.Map;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class JavascriptFilter
implements Filter {
    @Override
    public Object format(TemplateContext templateContext, Object data, Map<String, Object> parameters2) {
        StringBuilder javascriptString = new StringBuilder();
        javascriptString.append('\"');
        for (char c : String.valueOf(data).toCharArray()) {
            if (c == '\r') {
                javascriptString.append("\\r");
                continue;
            }
            if (c == '\n') {
                javascriptString.append("\\n");
                continue;
            }
            if (c == '\t') {
                javascriptString.append("\\t");
                continue;
            }
            if (c == '\"' || c == '\\') {
                javascriptString.append('\\');
                javascriptString.append(c);
                continue;
            }
            if (c < ' ') {
                javascriptString.append("\\x").append(BaseEncoding.base16().lowerCase().encode(new byte[]{(byte)c}));
                continue;
            }
            javascriptString.append(c);
        }
        javascriptString.append('\"');
        return javascriptString.toString();
    }
}

