/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.SoneProvider;
import net.pterodactylus.sone.template.RenderFilterKt;
import net.pterodactylus.sone.template.SoneAccessor;
import net.pterodactylus.sone.text.FreemailPart;
import net.pterodactylus.sone.text.FreenetLinkPart;
import net.pterodactylus.sone.text.LinkPart;
import net.pterodactylus.sone.text.Part;
import net.pterodactylus.sone.text.PlainTextPart;
import net.pterodactylus.sone.text.PostPart;
import net.pterodactylus.sone.text.SonePart;
import net.pterodactylus.sone.text.SoneTextParser;
import net.pterodactylus.sone.text.SoneTextParserContext;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.HtmlFilter;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ6\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J0\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0002J\f\u0010,\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/pterodactylus/sone/template/RenderFilter;", "Lnet/pterodactylus/util/template/Filter;", "soneProvider", "Lnet/pterodactylus/sone/database/SoneProvider;", "soneTextParser", "Lnet/pterodactylus/sone/text/SoneTextParser;", "htmlFilter", "Lnet/pterodactylus/util/template/HtmlFilter;", "(Lnet/pterodactylus/sone/database/SoneProvider;Lnet/pterodactylus/sone/text/SoneTextParser;Lnet/pterodactylus/util/template/HtmlFilter;)V", "templateContextFactory", "Lnet/pterodactylus/util/template/TemplateContextFactory;", "format", "", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "data", "parameters", "", "", "render", "", "writer", "Ljava/io/Writer;", "parts", "", "Lnet/pterodactylus/sone/text/Part;", "freemailPart", "Lnet/pterodactylus/sone/text/FreemailPart;", "freenetLinkPart", "Lnet/pterodactylus/sone/text/FreenetLinkPart;", "linkPart", "Lnet/pterodactylus/sone/text/LinkPart;", "part", "plainTextPart", "Lnet/pterodactylus/sone/text/PlainTextPart;", "postPart", "Lnet/pterodactylus/sone/text/PostPart;", "sonePart", "Lnet/pterodactylus/sone/text/SonePart;", "renderLink", "link", "text", "title", "cssClass", "urlEncode", "Sone"})
public final class RenderFilter
implements Filter {
    private final TemplateContextFactory templateContextFactory;
    private final SoneProvider soneProvider;
    private final SoneTextParser soneTextParser;

    @Override
    @Nullable
    public Object format(@Nullable TemplateContext templateContext, @Nullable Object data, @Nullable Map<String, Object> parameters2) {
        Object object = data;
        if (!(object instanceof Iterable)) {
            object = null;
        }
        Iterable iterable = (Iterable)object;
        if (iterable == null) {
            return null;
        }
        Iterable parts = iterable;
        StringWriter parsedTextWriter = new StringWriter();
        this.render((Writer)parsedTextWriter, parts);
        return parsedTextWriter.toString();
    }

    private final void render(Writer writer, Iterable<? extends Part> parts) {
        Iterable<? extends Part> $this$forEach$iv = parts;
        boolean $i$f$forEach = false;
        Iterator<? extends Part> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Part element$iv;
            Part it = element$iv = iterator2.next();
            boolean bl = false;
            this.render(writer, it);
        }
    }

    private final void render(Writer writer, Part part) {
        Part part2 = part;
        if (part2 instanceof PlainTextPart) {
            this.render(writer, (PlainTextPart)part);
        } else if (part2 instanceof FreenetLinkPart) {
            this.render(writer, (FreenetLinkPart)part);
        } else if (part2 instanceof LinkPart) {
            this.render(writer, (LinkPart)part);
        } else if (part2 instanceof SonePart) {
            this.render(writer, (SonePart)part);
        } else if (part2 instanceof PostPart) {
            this.render(writer, (PostPart)part);
        } else if (part2 instanceof FreemailPart) {
            this.render(writer, (FreemailPart)part);
        }
    }

    private final void render(Writer writer, PlainTextPart plainTextPart) {
        TemplateContext templateContext = this.templateContextFactory.createTemplateContext();
        templateContext.set("text", plainTextPart.getText());
        RenderFilterKt.access$getPlainTextTemplate$p().render(templateContext, writer);
    }

    private final void render(Writer writer, FreenetLinkPart freenetLinkPart) {
        this.renderLink(writer, '/' + freenetLinkPart.getLink(), freenetLinkPart.getText(), freenetLinkPart.getTitle(), freenetLinkPart.getTrusted() ? "freenet-trusted" : "freenet");
    }

    private final void render(Writer writer, LinkPart linkPart) {
        this.renderLink(writer, "/external-link/?_CHECKED_HTTP_=" + this.urlEncode(linkPart.getLink()), linkPart.getText(), linkPart.getTitle(), "internet");
    }

    private final String urlEncode(@NotNull String $this$urlEncode) {
        String string = URLEncoder.encode($this$urlEncode, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull(string, "URLEncoder.encode(this, \"UTF-8\")");
        return string;
    }

    private final void render(Writer writer, SonePart sonePart) {
        if (sonePart.getSone().getName() != null) {
            String string = "viewSone.html?sone=" + sonePart.getSone().getId();
            String string2 = SoneAccessor.getNiceName(sonePart.getSone());
            Intrinsics.checkExpressionValueIsNotNull(string2, "SoneAccessor.getNiceName(sonePart.sone)");
            String string3 = SoneAccessor.getNiceName(sonePart.getSone());
            Intrinsics.checkExpressionValueIsNotNull(string3, "SoneAccessor.getNiceName(sonePart.sone)");
            this.renderLink(writer, string, string2, string3, "in-sone");
        } else {
            this.renderLink(writer, "/WebOfTrust/ShowIdentity?id=" + sonePart.getSone().getId(), sonePart.getSone().getId(), sonePart.getSone().getId(), "in-sone");
        }
    }

    private final void render(Writer writer, PostPart postPart) {
        Post post = postPart.getPost();
        Intrinsics.checkExpressionValueIsNotNull(post, "postPart.post");
        SoneTextParserContext parserContext = new SoneTextParserContext(post.getSone());
        Post post2 = postPart.getPost();
        Intrinsics.checkExpressionValueIsNotNull(post2, "postPart.post");
        String string = post2.getText();
        Intrinsics.checkExpressionValueIsNotNull(string, "postPart.post.text");
        List<Part> parts = this.soneTextParser.parse(string, parserContext);
        StringBuilder excerpt = new StringBuilder();
        for (Part part : parts) {
            excerpt.append(part.getText());
            if (excerpt.length() <= 20) continue;
            int lastSpace = excerpt.lastIndexOf(" ", 20);
            if (lastSpace > -1) {
                excerpt.setLength(lastSpace);
            } else {
                excerpt.setLength(20);
            }
            excerpt.append("\u2026");
            break;
        }
        String string2 = "viewPost.html?post=" + postPart.getPost().getId();
        String string3 = excerpt.toString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "excerpt.toString()");
        Post post3 = postPart.getPost();
        Intrinsics.checkExpressionValueIsNotNull(post3, "postPart.post");
        String string4 = SoneAccessor.getNiceName(post3.getSone());
        Intrinsics.checkExpressionValueIsNotNull(string4, "SoneAccessor.getNiceName(postPart.post.sone)");
        this.renderLink(writer, string2, string3, string4, "in-sone");
    }

    private final void render(Writer writer, FreemailPart freemailPart) {
        Object object;
        block3: {
            block2: {
                String string = freemailPart.getIdentityId();
                Intrinsics.checkExpressionValueIsNotNull(string, "freemailPart.identityId");
                Sone sone = this.soneProvider.getSone(string);
                object = sone;
                if (object == null) break block2;
                Sone sone2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Sone p1 = sone2;
                boolean bl3 = false;
                object = SoneAccessor.getNiceName(p1);
                if (object != null) break block3;
            }
            object = freemailPart.getIdentityId();
        }
        Object soneName = object;
        this.renderLink(writer, "/Freemail/NewMessage?to=" + freemailPart.getIdentityId(), freemailPart.getEmailLocalPart() + '@' + (String)soneName + ".freemail", (String)soneName + '\n' + freemailPart.getEmailLocalPart() + '@' + freemailPart.getFreemailId() + ".freemail", "in-sone");
    }

    private final void renderLink(Writer writer, String link, String text, String title, String cssClass) {
        TemplateContext templateContext = this.templateContextFactory.createTemplateContext();
        templateContext.set("cssClass", cssClass);
        templateContext.set("link", link);
        templateContext.set("text", text);
        templateContext.set("title", title);
        RenderFilterKt.access$getLinkTemplate$p().render(templateContext, writer);
    }

    public RenderFilter(@NotNull SoneProvider soneProvider, @NotNull SoneTextParser soneTextParser, @NotNull HtmlFilter htmlFilter) {
        TemplateContextFactory templateContextFactory;
        Intrinsics.checkParameterIsNotNull(soneProvider, "soneProvider");
        Intrinsics.checkParameterIsNotNull(soneTextParser, "soneTextParser");
        Intrinsics.checkParameterIsNotNull(htmlFilter, "htmlFilter");
        this.soneProvider = soneProvider;
        this.soneTextParser = soneTextParser;
        TemplateContextFactory templateContextFactory2 = new TemplateContextFactory();
        RenderFilter renderFilter = this;
        boolean bl = false;
        boolean bl2 = false;
        TemplateContextFactory $this$apply = templateContextFactory2;
        boolean bl3 = false;
        $this$apply.addFilter("html", htmlFilter);
        renderFilter.templateContextFactory = templateContextFactory = templateContextFactory2;
    }
}

