/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.template;

import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.util.template.ReflectionAccessor;
import net.pterodactylus.util.template.TemplateContext;

public class ReplyAccessor
extends ReflectionAccessor {
    private final Core core;

    public ReplyAccessor(Core core) {
        this.core = core;
    }

    @Override
    public Object get(TemplateContext templateContext, Object object, String member) {
        PostReply reply = (PostReply)object;
        if ("likes".equals(member)) {
            return this.core.getLikes(reply);
        }
        if (member.equals("liked")) {
            Sone currentSone = (Sone)templateContext.get("currentSone");
            return currentSone != null && currentSone.isLikedReplyId(reply.getId());
        }
        if (member.equals("new")) {
            return !reply.isKnown();
        }
        if (member.equals("loaded")) {
            return reply.getSone() != null;
        }
        return super.get(templateContext, object, member);
    }
}

