/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.text;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.MarkPostKnownEvent;
import net.pterodactylus.sone.core.event.MentionOfLocalSoneFoundEvent;
import net.pterodactylus.sone.core.event.MentionOfLocalSoneRemovedEvent;
import net.pterodactylus.sone.core.event.NewPostFoundEvent;
import net.pterodactylus.sone.core.event.NewPostReplyFoundEvent;
import net.pterodactylus.sone.core.event.PostRemovedEvent;
import net.pterodactylus.sone.core.event.PostReplyRemovedEvent;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.database.PostReplyProvider;
import net.pterodactylus.sone.text.SoneMentionDetector;
import net.pterodactylus.sone.text.SoneMentionDetector$onNewPostReply$;
import net.pterodactylus.sone.text.SonePart;
import net.pterodactylus.sone.text.SoneTextParser;
import net.pterodactylus.sone.utils.BooleansKt;
import net.pterodactylus.sone.utils.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\f\u0010 \u001a\u00020!*\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lnet/pterodactylus/sone/text/SoneMentionDetector;", "", "eventBus", "Lcom/google/common/eventbus/EventBus;", "soneTextParser", "Lnet/pterodactylus/sone/text/SoneTextParser;", "postReplyProvider", "Lnet/pterodactylus/sone/database/PostReplyProvider;", "(Lcom/google/common/eventbus/EventBus;Lnet/pterodactylus/sone/text/SoneTextParser;Lnet/pterodactylus/sone/database/PostReplyProvider;)V", "mentionedPosts", "", "Lnet/pterodactylus/sone/data/Post;", "replies", "", "Lnet/pterodactylus/sone/data/PostReply;", "getReplies", "(Lnet/pterodactylus/sone/data/Post;)Ljava/util/List;", "onNewPost", "", "newPostFoundEvent", "Lnet/pterodactylus/sone/core/event/NewPostFoundEvent;", "onNewPostReply", "event", "Lnet/pterodactylus/sone/core/event/NewPostReplyFoundEvent;", "onPostMarkedKnown", "Lnet/pterodactylus/sone/core/event/MarkPostKnownEvent;", "onPostRemoved", "Lnet/pterodactylus/sone/core/event/PostRemovedEvent;", "onReplyRemoved", "Lnet/pterodactylus/sone/core/event/PostReplyRemovedEvent;", "unmentionPost", "post", "hasLinksToLocalSones", "", "", "Sone"})
public final class SoneMentionDetector {
    private final Set<Post> mentionedPosts;
    private final EventBus eventBus;
    private final SoneTextParser soneTextParser;
    private final PostReplyProvider postReplyProvider;

    @Subscribe
    public final void onNewPost(@NotNull NewPostFoundEvent newPostFoundEvent) {
        Intrinsics.checkParameterIsNotNull(newPostFoundEvent, "newPostFoundEvent");
        Post post = newPostFoundEvent.getPost();
        boolean bl = false;
        boolean bl2 = false;
        Post post2 = post;
        boolean bl3 = false;
        Sone sone = post2.getSone();
        Intrinsics.checkExpressionValueIsNotNull(sone, "post.sone");
        BooleansKt.onFalse(sone.isLocal(), new Function0<Unit>(post2, this){
            final /* synthetic */ Post $post;
            final /* synthetic */ SoneMentionDetector this$0;
            {
                this.$post = post;
                this.this$0 = soneMentionDetector;
                super(0);
            }

            public final void invoke() {
                String string = this.$post.getText();
                Intrinsics.checkExpressionValueIsNotNull(string, "post.text");
                if (SoneMentionDetector.access$hasLinksToLocalSones(this.this$0, string)) {
                    Collection collection = SoneMentionDetector.access$getMentionedPosts$p(this.this$0);
                    Post post = this.$post;
                    boolean bl = false;
                    collection.add(post);
                    SoneMentionDetector.access$getEventBus$p(this.this$0).post(new MentionOfLocalSoneFoundEvent(this.$post));
                }
            }
        });
    }

    @Subscribe
    public final void onNewPostReply(@NotNull NewPostReplyFoundEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        PostReply postReply = event.getPostReply();
        boolean bl = false;
        boolean bl2 = false;
        PostReply postReply2 = postReply;
        boolean bl3 = false;
        Sone sone = postReply2.getSone();
        Intrinsics.checkExpressionValueIsNotNull(sone, "postReply.sone");
        BooleansKt.onFalse(sone.isLocal(), new Function0<Unit>(postReply2, this){
            final /* synthetic */ PostReply $postReply;
            final /* synthetic */ SoneMentionDetector this$0;
            {
                this.$postReply = postReply;
                this.this$0 = soneMentionDetector;
                super(0);
            }

            public final void invoke() {
                block1: {
                    String string = this.$postReply.getText();
                    Intrinsics.checkExpressionValueIsNotNull(string, "postReply.text");
                    if (!SoneMentionDetector.access$hasLinksToLocalSones(this.this$0, string)) break block1;
                    Optional<Post> optional = this.$postReply.getPost();
                    Intrinsics.checkExpressionValueIsNotNull(optional, "postReply.post");
                    MentionOfLocalSoneFoundEvent mentionOfLocalSoneFoundEvent = (MentionOfLocalSoneFoundEvent)OptionalsKt.let(OptionalsKt.also(optional, (Function1)new Function1<Post, Unit>(this){
                        final /* synthetic */ onNewPostReply$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(Post it) {
                            Collection collection = SoneMentionDetector.access$getMentionedPosts$p(this.this$0.this$0);
                            boolean bl = false;
                            collection.add(it);
                        }
                    }), onNewPostReply.1.2.INSTANCE);
                    if (mentionOfLocalSoneFoundEvent != null) {
                        MentionOfLocalSoneFoundEvent mentionOfLocalSoneFoundEvent2 = mentionOfLocalSoneFoundEvent;
                        EventBus eventBus = SoneMentionDetector.access$getEventBus$p(this.this$0);
                        boolean bl = false;
                        boolean bl2 = false;
                        MentionOfLocalSoneFoundEvent p1 = mentionOfLocalSoneFoundEvent2;
                        boolean bl3 = false;
                        eventBus.post(p1);
                    }
                }
            }
        });
    }

    @Subscribe
    public final void onPostRemoved(@NotNull PostRemovedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.unmentionPost(event.getPost());
    }

    @Subscribe
    public final void onPostMarkedKnown(@NotNull MarkPostKnownEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.unmentionPost(event.getPost());
    }

    @Subscribe
    public final void onReplyRemoved(@NotNull PostReplyRemovedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Optional<Post> optional = event.getPostReply().getPost();
        Intrinsics.checkExpressionValueIsNotNull(optional, "event.postReply.post");
        OptionalsKt.let(optional, (Function1)new Function1<Post, Unit>(this, event){
            final /* synthetic */ SoneMentionDetector this$0;
            final /* synthetic */ PostReplyRemovedEvent $event;

            /*
             * WARNING - void declaration
             */
            public final void invoke(Post it) {
                Post post = it;
                Intrinsics.checkExpressionValueIsNotNull(post, "it");
                String string = post.getText();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.text");
                if (!SoneMentionDetector.access$hasLinksToLocalSones(this.this$0, string) || it.isKnown()) {
                    boolean bl;
                    block6: {
                        void $this$filterNotTo$iv$iv;
                        Iterable $this$filterNot$iv = SoneMentionDetector.access$getReplies$p(this.this$0, it);
                        boolean $i$f$filterNot = false;
                        Iterable iterable = $this$filterNot$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            PostReply it2 = (PostReply)element$iv$iv;
                            boolean bl2 = false;
                            if (Intrinsics.areEqual(it2, this.$event.getPostReply())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$none$iv = (List)destination$iv$iv;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (E element$iv : $this$none$iv) {
                                PostReply it3 = (PostReply)element$iv;
                                boolean bl3 = false;
                                String string2 = it3.getText();
                                Intrinsics.checkExpressionValueIsNotNull(string2, "it.text");
                                if (!(SoneMentionDetector.access$hasLinksToLocalSones(this.this$0, string2) && !it3.isKnown())) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        SoneMentionDetector.access$unmentionPost(this.this$0, it);
                    }
                }
            }
            {
                this.this$0 = soneMentionDetector;
                this.$event = postReplyRemovedEvent;
                super(1);
            }
        });
    }

    private final void unmentionPost(Post post) {
        if (this.mentionedPosts.contains(post)) {
            this.eventBus.post(new MentionOfLocalSoneRemovedEvent(post));
            Collection collection = this.mentionedPosts;
            boolean bl = false;
            collection.remove(post);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasLinksToLocalSones(@NotNull String $this$hasLinksToLocalSones) {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.soneTextParser.parse($this$hasLinksToLocalSones, null);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SonePart)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SonePart it = (SonePart)element$iv;
                    boolean bl2 = false;
                    if (!it.getSone().isLocal()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<PostReply> getReplies(@NotNull Post $this$replies) {
        String string = $this$replies.getId();
        Intrinsics.checkExpressionValueIsNotNull(string, "id");
        return this.postReplyProvider.getReplies(string);
    }

    @Inject
    public SoneMentionDetector(@NotNull EventBus eventBus, @NotNull SoneTextParser soneTextParser, @NotNull PostReplyProvider postReplyProvider) {
        Set set;
        Intrinsics.checkParameterIsNotNull(eventBus, "eventBus");
        Intrinsics.checkParameterIsNotNull(soneTextParser, "soneTextParser");
        Intrinsics.checkParameterIsNotNull(postReplyProvider, "postReplyProvider");
        this.eventBus = eventBus;
        this.soneTextParser = soneTextParser;
        this.postReplyProvider = postReplyProvider;
        SoneMentionDetector soneMentionDetector = this;
        boolean bl = false;
        soneMentionDetector.mentionedPosts = set = (Set)new LinkedHashSet();
    }

    public static final /* synthetic */ boolean access$hasLinksToLocalSones(SoneMentionDetector $this, String $this$access_u24hasLinksToLocalSones) {
        return $this.hasLinksToLocalSones($this$access_u24hasLinksToLocalSones);
    }

    public static final /* synthetic */ Set access$getMentionedPosts$p(SoneMentionDetector $this) {
        return $this.mentionedPosts;
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(SoneMentionDetector $this) {
        return $this.eventBus;
    }

    public static final /* synthetic */ List access$getReplies$p(SoneMentionDetector $this, Post $this$access_u24replies_u24p) {
        return $this.getReplies($this$access_u24replies_u24p);
    }

    public static final /* synthetic */ void access$unmentionPost(SoneMentionDetector $this, Post post) {
        $this.unmentionPost(post);
    }
}

