/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.text.Part;
import net.pterodactylus.sone.text.PlainTextPart;
import net.pterodactylus.sone.text.SoneTextParserContext;
import net.pterodactylus.sone.text.SoneTextParserKt;
import net.pterodactylus.sone.utils.FreenetKt;
import org.bitpedia.util.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0001*\b\u0012\u0004\u0012\u00020\u001e0\u0001H\u0002\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\b\u0012\u0004\u0012\u00020\u00060\u0001H\u0002\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u0001*\b\u0012\u0004\u0012\u00020\u001e0\u0001H\u0002\u001a2\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\u0001\"\u0004\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"0\u00012\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H\"0$H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\"\u0018\u0010\u0012\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\"\u0018\u0010\u0014\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\"\u0018\u0010\u0016\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\b\"\u0018\u0010\u0018\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\b\u00a8\u0006%"}, d2={"punctuationChars", "", "", "whitespace", "Lkotlin/text/Regex;", "decodedId", "", "getDecodedId", "(Ljava/lang/String;)Ljava/lang/String;", "routingKey", "", "Lnet/pterodactylus/sone/data/Sone;", "getRoutingKey", "(Lnet/pterodactylus/sone/data/Sone;)[B", "Lnet/pterodactylus/sone/text/SoneTextParserContext;", "(Lnet/pterodactylus/sone/text/SoneTextParserContext;)[B", "withoutMiddlePathComponents", "getWithoutMiddlePathComponents", "withoutProtocol", "getWithoutProtocol", "withoutTrailingSlash", "getWithoutTrailingSlash", "withoutUrlParameters", "getWithoutUrlParameters", "withoutWwwPrefix", "getWithoutWwwPrefix", "isPunctuation", "", "char", "mergeAdjacentPlainTextParts", "Lnet/pterodactylus/sone/text/Part;", "mergeMultipleEmptyLines", "removeEmptyPlainTextParts", "replaceFirst", "T", "replacement", "Lkotlin/Function1;", "Sone"})
public final class SoneTextParserKt {
    private static final List<Character> punctuationChars = CollectionsKt.listOf(Character.valueOf('.'), Character.valueOf(','), Character.valueOf('?'), Character.valueOf('!'));
    private static final Regex whitespace = new Regex("[\\u000a \u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u200c\u200d\u202f\u205f\u2060\u2800\u3000]");

    /*
     * WARNING - void declaration
     */
    private static final List<String> mergeMultipleEmptyLines(@NotNull List<String> $this$mergeMultipleEmptyLines) {
        void $this$fold$iv;
        Iterable iterable = $this$mergeMultipleEmptyLines;
        List<String> initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void current;
            String string = (String)element$iv;
            List<String> previous = accumulator$iv;
            boolean bl = false;
            accumulator$iv = previous.isEmpty() ? CollectionsKt.plus((Collection)previous, current) : (Intrinsics.areEqual(CollectionsKt.last(previous), "\n") && Intrinsics.areEqual(current, "") ? previous : CollectionsKt.plus((Collection)previous, "\n" + (String)current));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Part> mergeAdjacentPlainTextParts(@NotNull List<? extends Part> $this$mergeAdjacentPlainTextParts) {
        void $this$fold$iv;
        Iterable iterable = $this$mergeAdjacentPlainTextParts;
        List<Part> initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void part;
            Part part2 = (Part)element$iv;
            List<Part> parts = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.lastOrNull(parts) instanceof PlainTextPart && part instanceof PlainTextPart ? CollectionsKt.plus((Collection)CollectionsKt.dropLast(parts, 1), new PlainTextPart(CollectionsKt.last(parts).getText() + part.getText())) : CollectionsKt.plus((Collection)parts, part);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Part> removeEmptyPlainTextParts(@NotNull List<? extends Part> $this$removeEmptyPlainTextParts) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$removeEmptyPlainTextParts;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Part it = (Part)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, new PlainTextPart(""))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final String getDecodedId(@NotNull String $this$decodedId) {
        byte[] byArray = Base32.decode((String)$this$decodedId);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "Base32.decode(this)");
        return FreenetKt.getAsFreenetBase64(byArray);
    }

    private static final String getWithoutProtocol(@NotNull String $this$withoutProtocol) {
        String string = $this$withoutProtocol;
        int n = StringsKt.indexOf$default((CharSequence)$this$withoutProtocol, "//", 0, false, 6, null) + 2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
        return string3;
    }

    private static final String getWithoutUrlParameters(@NotNull String $this$withoutUrlParameters) {
        return (String)CollectionsKt.first(StringsKt.split$default((CharSequence)$this$withoutUrlParameters, new char[]{'?'}, false, 0, 6, null));
    }

    private static final String getWithoutWwwPrefix(@NotNull String $this$withoutWwwPrefix) {
        return CollectionsKt.joinToString$default(SoneTextParserKt.replaceFirst(StringsKt.split$default((CharSequence)$this$withoutWwwPrefix, new String[]{"/"}, false, 0, 6, null), withoutWwwPrefix.1.INSTANCE), "/", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> replaceFirst(@NotNull List<? extends T> $this$replaceFirst, Function1<? super T, ? extends T> replacement) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$replaceFirst;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void element;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Object t = item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            void var18_18 = index == false ? replacement.invoke(element) : element;
            collection2.add(var18_18);
        }
        return (List)destination$iv$iv;
    }

    private static final String getWithoutMiddlePathComponents(@NotNull String $this$withoutMiddlePathComponents) {
        List list = StringsKt.split$default((CharSequence)$this$withoutMiddlePathComponents, new String[]{"/"}, false, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        return it.size() > 2 ? (String)CollectionsKt.first(it) + "/\u2026/" + (String)CollectionsKt.last(it) : CollectionsKt.joinToString$default(it, "/", null, null, 0, null, null, 62, null);
    }

    private static final String getWithoutTrailingSlash(@NotNull String $this$withoutTrailingSlash) {
        String string;
        if (StringsKt.endsWith$default($this$withoutTrailingSlash, "/", false, 2, null)) {
            String string2 = $this$withoutTrailingSlash;
            int n = 0;
            int n2 = $this$withoutTrailingSlash.length() - 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = $this$withoutTrailingSlash;
        }
        return string;
    }

    private static final byte[] getRoutingKey(@NotNull SoneTextParserContext $this$routingKey) {
        Sone sone = $this$routingKey.getPostingSone();
        return (byte[])(sone != null ? SoneTextParserKt.getRoutingKey(sone) : null);
    }

    private static final byte[] getRoutingKey(@NotNull Sone $this$routingKey) {
        return FreenetKt.getFromFreenetBase64($this$routingKey.getId());
    }

    private static final boolean isPunctuation(char c) {
        return punctuationChars.contains(Character.valueOf(c));
    }

    public static final /* synthetic */ List access$mergeAdjacentPlainTextParts(List $this$access_u24mergeAdjacentPlainTextParts) {
        return SoneTextParserKt.mergeAdjacentPlainTextParts($this$access_u24mergeAdjacentPlainTextParts);
    }

    public static final /* synthetic */ List access$removeEmptyPlainTextParts(List $this$access_u24removeEmptyPlainTextParts) {
        return SoneTextParserKt.removeEmptyPlainTextParts($this$access_u24removeEmptyPlainTextParts);
    }

    public static final /* synthetic */ List access$mergeMultipleEmptyLines(List $this$access_u24mergeMultipleEmptyLines) {
        return SoneTextParserKt.mergeMultipleEmptyLines($this$access_u24mergeMultipleEmptyLines);
    }

    public static final /* synthetic */ byte[] access$getRoutingKey$p(SoneTextParserContext $this$access_u24routingKey_u24p) {
        return SoneTextParserKt.getRoutingKey($this$access_u24routingKey_u24p);
    }

    public static final /* synthetic */ String access$getDecodedId$p(String $this$access_u24decodedId_u24p) {
        return SoneTextParserKt.getDecodedId($this$access_u24decodedId_u24p);
    }

    public static final /* synthetic */ String access$getWithoutProtocol$p(String $this$access_u24withoutProtocol_u24p) {
        return SoneTextParserKt.getWithoutProtocol($this$access_u24withoutProtocol_u24p);
    }

    public static final /* synthetic */ String access$getWithoutWwwPrefix$p(String $this$access_u24withoutWwwPrefix_u24p) {
        return SoneTextParserKt.getWithoutWwwPrefix($this$access_u24withoutWwwPrefix_u24p);
    }

    public static final /* synthetic */ String access$getWithoutUrlParameters$p(String $this$access_u24withoutUrlParameters_u24p) {
        return SoneTextParserKt.getWithoutUrlParameters($this$access_u24withoutUrlParameters_u24p);
    }

    public static final /* synthetic */ String access$getWithoutMiddlePathComponents$p(String $this$access_u24withoutMiddlePathComponents_u24p) {
        return SoneTextParserKt.getWithoutMiddlePathComponents($this$access_u24withoutMiddlePathComponents_u24p);
    }

    public static final /* synthetic */ String access$getWithoutTrailingSlash$p(String $this$access_u24withoutTrailingSlash_u24p) {
        return SoneTextParserKt.getWithoutTrailingSlash($this$access_u24withoutTrailingSlash_u24p);
    }

    public static final /* synthetic */ Regex access$getWhitespace$p() {
        return whitespace;
    }

    public static final /* synthetic */ boolean access$isPunctuation(char c) {
        return SoneTextParserKt.isPunctuation(c);
    }
}

