/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.MarkPostReplyKnownEvent;
import net.pterodactylus.sone.core.event.NewPostReplyFoundEvent;
import net.pterodactylus.sone.core.event.PostReplyRemovedEvent;
import net.pterodactylus.sone.data.PostReply;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.sone.notify.NotificationsKt;
import net.pterodactylus.sone.web.notification.LocalReplyHandlerKt;
import net.pterodactylus.util.notify.NotificationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/pterodactylus/sone/web/notification/LocalReplyHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "notification", "Lnet/pterodactylus/sone/notify/ListNotification;", "Lnet/pterodactylus/sone/data/PostReply;", "(Lnet/pterodactylus/util/notify/NotificationManager;Lnet/pterodactylus/sone/notify/ListNotification;)V", "newReplyFound", "", "event", "Lnet/pterodactylus/sone/core/event/NewPostReplyFoundEvent;", "replyMarkedAsKnown", "Lnet/pterodactylus/sone/core/event/MarkPostReplyKnownEvent;", "replyRemoved", "Lnet/pterodactylus/sone/core/event/PostReplyRemovedEvent;", "Sone"})
public final class LocalReplyHandler {
    private final NotificationManager notificationManager;
    private final ListNotification<PostReply> notification;

    @Subscribe
    public final void newReplyFound(@NotNull NewPostReplyFoundEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        LocalReplyHandlerKt.access$onLocal(event.getPostReply(), new Function1<PostReply, Unit>(this){
            final /* synthetic */ LocalReplyHandler this$0;

            public final void invoke(@NotNull PostReply it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                LocalReplyHandler.access$getNotification$p(this.this$0).add(it);
                if (!NotificationsKt.hasFirstStartNotification(LocalReplyHandler.access$getNotificationManager$p(this.this$0))) {
                    LocalReplyHandler.access$getNotificationManager$p(this.this$0).addNotification(LocalReplyHandler.access$getNotification$p(this.this$0));
                }
            }
            {
                this.this$0 = localReplyHandler;
                super(1);
            }
        });
    }

    @Subscribe
    public final void replyRemoved(@NotNull PostReplyRemovedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.notification.remove(event.getPostReply());
    }

    @Subscribe
    public final void replyMarkedAsKnown(@NotNull MarkPostReplyKnownEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.notification.remove(event.getPostReply());
    }

    @Inject
    public LocalReplyHandler(@NotNull NotificationManager notificationManager, @Named(value="localReply") @NotNull ListNotification<PostReply> notification) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(notification, "notification");
        this.notificationManager = notificationManager;
        this.notification = notification;
    }

    public static final /* synthetic */ ListNotification access$getNotification$p(LocalReplyHandler $this) {
        return $this.notification;
    }

    public static final /* synthetic */ NotificationManager access$getNotificationManager$p(LocalReplyHandler $this) {
        return $this.notificationManager;
    }
}

