/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import java.util.function.Consumer;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.NewPostFoundEvent;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.notify.NotificationsKt;
import net.pterodactylus.sone.utils.FunctionsKt;
import net.pterodactylus.util.notify.NotificationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/pterodactylus/sone/web/notification/MarkPostKnownDuringFirstStartHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "markPostAsKnown", "Ljava/util/function/Consumer;", "Lnet/pterodactylus/sone/data/Post;", "(Lnet/pterodactylus/util/notify/NotificationManager;Ljava/util/function/Consumer;)V", "newPostFound", "", "newPostFoundEvent", "Lnet/pterodactylus/sone/core/event/NewPostFoundEvent;", "Sone"})
public final class MarkPostKnownDuringFirstStartHandler {
    private final NotificationManager notificationManager;
    private final Consumer<Post> markPostAsKnown;

    @Subscribe
    public final void newPostFound(@NotNull NewPostFoundEvent newPostFoundEvent) {
        Intrinsics.checkParameterIsNotNull(newPostFoundEvent, "newPostFoundEvent");
        if (NotificationsKt.hasFirstStartNotification(this.notificationManager)) {
            FunctionsKt.invoke(this.markPostAsKnown, newPostFoundEvent.getPost());
        }
    }

    @Inject
    public MarkPostKnownDuringFirstStartHandler(@NotNull NotificationManager notificationManager, @NotNull Consumer<Post> markPostAsKnown) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(markPostAsKnown, "markPostAsKnown");
        this.notificationManager = notificationManager;
        this.markPostAsKnown = markPostAsKnown;
    }
}

