/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.MarkPostKnownEvent;
import net.pterodactylus.sone.core.event.NewPostFoundEvent;
import net.pterodactylus.sone.core.event.PostRemovedEvent;
import net.pterodactylus.sone.data.Post;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.notify.ListNotification;
import net.pterodactylus.sone.notify.NotificationsKt;
import net.pterodactylus.util.notify.NotificationManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/pterodactylus/sone/web/notification/NewRemotePostHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "notification", "Lnet/pterodactylus/sone/notify/ListNotification;", "Lnet/pterodactylus/sone/data/Post;", "(Lnet/pterodactylus/util/notify/NotificationManager;Lnet/pterodactylus/sone/notify/ListNotification;)V", "newPostFound", "", "newPostFoundEvent", "Lnet/pterodactylus/sone/core/event/NewPostFoundEvent;", "postMarkedKnown", "event", "Lnet/pterodactylus/sone/core/event/MarkPostKnownEvent;", "postRemoved", "Lnet/pterodactylus/sone/core/event/PostRemovedEvent;", "Sone"})
public final class NewRemotePostHandler {
    private final NotificationManager notificationManager;
    private final ListNotification<Post> notification;

    @Subscribe
    public final void newPostFound(@NotNull NewPostFoundEvent newPostFoundEvent) {
        Intrinsics.checkParameterIsNotNull(newPostFoundEvent, "newPostFoundEvent");
        Sone sone = newPostFoundEvent.getPost().getSone();
        Intrinsics.checkExpressionValueIsNotNull(sone, "newPostFoundEvent.post.sone");
        if (!sone.isLocal()) {
            this.notification.add(newPostFoundEvent.getPost());
            if (!NotificationsKt.hasFirstStartNotification(this.notificationManager)) {
                this.notificationManager.addNotification(this.notification);
            }
        }
    }

    @Subscribe
    public final void postRemoved(@NotNull PostRemovedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.notification.remove(event.getPost());
    }

    @Subscribe
    public final void postMarkedKnown(@NotNull MarkPostKnownEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.notification.remove(event.getPost());
    }

    @Inject
    public NewRemotePostHandler(@NotNull NotificationManager notificationManager, @Named(value="newRemotePost") @NotNull ListNotification<Post> notification) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(notification, "notification");
        this.notificationManager = notificationManager;
        this.notification = notification;
    }
}

