/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.notification;

import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.core.event.SoneInsertAbortedEvent;
import net.pterodactylus.sone.core.event.SoneInsertedEvent;
import net.pterodactylus.sone.core.event.SoneInsertingEvent;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneOptions;
import net.pterodactylus.util.notify.NotificationManager;
import net.pterodactylus.util.notify.TemplateNotification;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00070\u0005j\u0002`\t\u00a2\u0006\u0002\u0010\nJI\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2*\u0010\u0010\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u00120\u0011\"\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u001aH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u001c\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00070\u0005j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/pterodactylus/sone/web/notification/SoneInsertHandler;", "", "notificationManager", "Lnet/pterodactylus/util/notify/NotificationManager;", "soneNotifications", "Lkotlin/Function1;", "Lnet/pterodactylus/sone/data/Sone;", "Lkotlin/jvm/JvmSuppressWildcards;", "Lnet/pterodactylus/util/notify/TemplateNotification;", "Lnet/pterodactylus/sone/web/notification/SoneInsertNotificationSupplier;", "(Lnet/pterodactylus/util/notify/NotificationManager;Lkotlin/jvm/functions/Function1;)V", "showNotification", "", "sone", "status", "", "templateVariables", "", "Lkotlin/Pair;", "(Lnet/pterodactylus/sone/data/Sone;Ljava/lang/String;[Lkotlin/Pair;)V", "soneInsertAborted", "event", "Lnet/pterodactylus/sone/core/event/SoneInsertAbortedEvent;", "soneInserted", "Lnet/pterodactylus/sone/core/event/SoneInsertedEvent;", "soneInserting", "Lnet/pterodactylus/sone/core/event/SoneInsertingEvent;", "Sone"})
public final class SoneInsertHandler {
    private final NotificationManager notificationManager;
    private final Function1<Sone, TemplateNotification> soneNotifications;

    @Subscribe
    public final void soneInserting(@NotNull SoneInsertingEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.showNotification(event.getSone(), "inserting", new Pair[0]);
    }

    @Subscribe
    public final void soneInserted(@NotNull SoneInsertedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.showNotification(event.getSone(), "inserted", TuplesKt.to("insertDuration", event.getInsertDuration() / (long)1000));
    }

    @Subscribe
    public final void soneInsertAborted(@NotNull SoneInsertAbortedEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.showNotification(event.getSone(), "insert-aborted", new Pair[0]);
    }

    private final void showNotification(Sone sone, String status, Pair<String, ? extends Object> ... templateVariables) {
        SoneOptions soneOptions = sone.getOptions();
        Intrinsics.checkExpressionValueIsNotNull(soneOptions, "sone.options");
        if (soneOptions.isSoneInsertNotificationEnabled()) {
            TemplateNotification templateNotification = this.soneNotifications.invoke(sone);
            boolean bl = false;
            boolean bl2 = false;
            TemplateNotification notification = templateNotification;
            boolean bl3 = false;
            notification.set("soneStatus", status);
            Pair<String, ? extends Object>[] $this$forEach$iv = templateVariables;
            boolean $i$f$forEach = false;
            Pair<String, ? extends Object>[] pairArray = $this$forEach$iv;
            int n = pairArray.length;
            for (int j = 0; j < n; ++j) {
                Pair<String, ? extends Object> element$iv;
                Pair<String, ? extends Object> it = element$iv = pairArray[j];
                boolean bl4 = false;
                notification.set(it.getFirst(), it.getSecond());
            }
            this.notificationManager.addNotification(notification);
        }
    }

    @Inject
    public SoneInsertHandler(@NotNull NotificationManager notificationManager, @NotNull Function1<Sone, TemplateNotification> soneNotifications) {
        Intrinsics.checkParameterIsNotNull(notificationManager, "notificationManager");
        Intrinsics.checkParameterIsNotNull(soneNotifications, "soneNotifications");
        this.notificationManager = notificationManager;
        this.soneNotifications = soneNotifications;
    }
}

