/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.page;

import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.web.page.AnnotationsKt;
import net.pterodactylus.sone.web.page.DefaultPageMakerInteractionFactory;
import net.pterodactylus.sone.web.page.FreenetPage;
import net.pterodactylus.sone.web.page.FreenetRequest;
import net.pterodactylus.sone.web.page.FreenetTemplatePageKt;
import net.pterodactylus.sone.web.page.PageMakerInteraction;
import net.pterodactylus.sone.web.page.PageMakerInteractionFactory;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.web.Method;
import net.pterodactylus.util.web.RedirectResponse;
import net.pterodactylus.util.web.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lnet/pterodactylus/sone/web/page/FreenetTemplatePage;", "Lnet/pterodactylus/sone/web/page/FreenetPage;", "Lfreenet/clients/http/LinkEnabledCallback;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "invalidFormPasswordRedirectTarget", "", "(Lnet/pterodactylus/sone/web/page/TemplateRenderer;Lnet/pterodactylus/sone/main/Loaders;Ljava/lang/String;)V", "isFullAccessOnly", "", "()Z", "pageMakerInteractionFactory", "Lnet/pterodactylus/sone/web/page/PageMakerInteractionFactory;", "shortcutIcon", "getShortcutIcon", "()Ljava/lang/String;", "styleSheets", "", "getStyleSheets", "()Ljava/util/Collection;", "template", "Lnet/pterodactylus/util/template/Template;", "getAdditionalLinkNodes", "", "", "request", "Lnet/pterodactylus/sone/web/page/FreenetRequest;", "getPageTitle", "getPath", "getRedirectTarget", "handleRequest", "Lnet/pterodactylus/util/web/Response;", "response", "isEnabled", "toadletContext", "Lfreenet/clients/http/ToadletContext;", "isLinkExcepted", "link", "Ljava/net/URI;", "isPrefixPage", "processTemplate", "", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "redirectTo", "", "target", "RedirectException", "Sone"})
public class FreenetTemplatePage
implements FreenetPage,
LinkEnabledCallback {
    private final PageMakerInteractionFactory pageMakerInteractionFactory;
    @NotNull
    private final Collection<String> styleSheets;
    private final Template template;
    private final TemplateRenderer templateRenderer;
    private final String invalidFormPasswordRedirectTarget;

    @NotNull
    public Collection<String> getStyleSheets() {
        return this.styleSheets;
    }

    @Nullable
    public String getShortcutIcon() {
        return null;
    }

    public boolean isFullAccessOnly() {
        return false;
    }

    @Override
    @Nullable
    public String getPath() {
        return AnnotationsKt.getToadletPath(this);
    }

    @NotNull
    public String getPageTitle(@NotNull FreenetRequest request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        return "";
    }

    @Override
    public boolean isPrefixPage() {
        return false;
    }

    @Nullable
    public String getRedirectTarget(@NotNull FreenetRequest request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        return null;
    }

    @NotNull
    public List<Map<String, String>> getAdditionalLinkNodes(@NotNull FreenetRequest request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isLinkExcepted(@NotNull URI link) {
        Intrinsics.checkParameterIsNotNull(link, "link");
        return false;
    }

    public boolean isEnabled(@NotNull ToadletContext toadletContext) {
        Intrinsics.checkParameterIsNotNull(toadletContext, "toadletContext");
        return !this.isFullAccessOnly();
    }

    @Override
    @NotNull
    public Response handleRequest(@NotNull FreenetRequest request, @NotNull Response response) {
        String string;
        Object p1;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(response, "response");
        String string2 = this.getRedirectTarget(request);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String redirectTarget = string3;
            boolean bl32 = false;
            return new RedirectResponse(redirectTarget);
        }
        if (this.isFullAccessOnly() && !request.getToadletContext().isAllowedFullAccess()) {
            Response response2 = response.setStatusCode(401).setStatusText("Not authorized").setContentType("text/html");
            Intrinsics.checkExpressionValueIsNotNull(response2, "response.setStatusCode(4\u2026tContentType(\"text/html\")");
            return response2;
        }
        ToadletContext toadletContext = request.getToadletContext();
        if (request.getMethod() == Method.POST) {
            String formPassword = request.getHttpRequest().getPartAsStringFailsafe("formPassword", 32);
            ToadletContainer toadletContainer = toadletContext.getContainer();
            Intrinsics.checkExpressionValueIsNotNull(toadletContainer, "toadletContext.container");
            if (Intrinsics.areEqual(formPassword, toadletContainer.getFormPassword()) ^ true) {
                return new RedirectResponse(this.invalidFormPasswordRedirectTarget);
            }
        }
        PageMakerInteraction pageMakerInteraction = this.pageMakerInteractionFactory.createPageMaker(toadletContext, this.getPageTitle(request));
        Object $this$forEach$iv = this.getStyleSheets();
        boolean $i$f$forEach = false;
        Iterator bl32 = $this$forEach$iv.iterator();
        while (bl32.hasNext()) {
            element$iv = bl32.next();
            p1 = (String)element$iv;
            boolean bl = false;
            pageMakerInteraction.addStyleSheet((String)p1);
        }
        $this$forEach$iv = this.getAdditionalLinkNodes(request);
        $i$f$forEach = false;
        bl32 = $this$forEach$iv.iterator();
        while (bl32.hasNext()) {
            element$iv = bl32.next();
            p1 = (Map)element$iv;
            boolean bl = false;
            pageMakerInteraction.addLinkNode((Map<String, String>)p1);
        }
        String string4 = this.getShortcutIcon();
        if (string4 != null) {
            $this$forEach$iv = string4;
            $i$f$forEach = false;
            boolean bl32 = false;
            Object p12 = $this$forEach$iv;
            boolean bl = false;
            pageMakerInteraction.addShortcutIcon((String)p12);
        }
        try {
            long start2 = System.nanoTime();
            String string5 = this.templateRenderer.render(this.template, (Function1<? super TemplateContext, Unit>)new Function1<TemplateContext, Unit>(this, request){
                final /* synthetic */ FreenetTemplatePage this$0;
                final /* synthetic */ FreenetRequest $request;

                public final void invoke(@NotNull TemplateContext templateContext) {
                    Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
                    this.this$0.processTemplate(this.$request, templateContext);
                }
                {
                    this.this$0 = freenetTemplatePage;
                    this.$request = freenetRequest;
                    super(1);
                }
            });
            boolean bl = false;
            boolean bl4 = false;
            String it = string5;
            boolean bl5 = false;
            long finish = System.nanoTime();
            FreenetTemplatePageKt.access$getLogger$p().log(Level.FINEST, String.format("Template was rendered in %.2fms.", (double)(finish - start2) / 1000000.0));
            string = string5;
        }
        catch (RedirectException re1) {
            String string6 = re1.getTarget();
            if (string6 == null) {
                string6 = "";
            }
            return new RedirectResponse(string6);
        }
        String output2 = string;
        pageMakerInteraction.setContent(output2);
        Response response3 = response.setStatusCode(200).setStatusText("OK").setContentType("text/html").write(pageMakerInteraction.renderPage());
        Intrinsics.checkExpressionValueIsNotNull(response3, "response.setStatusCode(2\u2026Interaction.renderPage())");
        return response3;
    }

    public void processTemplate(@NotNull FreenetRequest request, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
    }

    @NotNull
    public final Void redirectTo(@Nullable String target) {
        throw (Throwable)new RedirectException(target);
    }

    public FreenetTemplatePage(@NotNull TemplateRenderer templateRenderer, @NotNull Loaders loaders, @NotNull String invalidFormPasswordRedirectTarget) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
                Intrinsics.checkParameterIsNotNull(loaders, "loaders");
                Intrinsics.checkParameterIsNotNull(invalidFormPasswordRedirectTarget, "invalidFormPasswordRedirectTarget");
                this.templateRenderer = templateRenderer;
                this.invalidFormPasswordRedirectTarget = invalidFormPasswordRedirectTarget;
                this.pageMakerInteractionFactory = new DefaultPageMakerInteractionFactory();
                this.styleSheets = SetsKt.emptySet();
                FreenetTemplatePage freenetTemplatePage = this;
                object = AnnotationsKt.getTemplatePath(this);
                if (object == null) break block2;
                String string = object;
                FreenetTemplatePage freenetTemplatePage2 = freenetTemplatePage;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string;
                boolean bl3 = false;
                Template template = loaders.loadTemplate(p1);
                freenetTemplatePage = freenetTemplatePage2;
                object = template;
                if (object != null) break block3;
            }
            object = new Template();
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "templatePath?.let(loader\u2026adTemplate) ?: Template()");
        freenetTemplatePage.template = object;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/pterodactylus/sone/web/page/FreenetTemplatePage$RedirectException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "target", "", "(Ljava/lang/String;)V", "getTarget", "()Ljava/lang/String;", "toString", "Sone"})
    public static final class RedirectException
    extends Exception {
        @Nullable
        private final String target;

        @Override
        @NotNull
        public String toString() {
            String string = String.format("RedirectException{target='%s'}", this.target);
            Intrinsics.checkExpressionValueIsNotNull(string, "format(\"RedirectException{target='%s'}\", target)");
            return string;
        }

        @Nullable
        public final String getTarget() {
            return this.target;
        }

        public RedirectException(@Nullable String target) {
            this.target = target;
        }
    }
}

