/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.pages;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.text.TextFilter;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.page.SoneRequest;
import net.pterodactylus.sone.web.page.TemplatePath;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.page.ToadletPath;
import net.pterodactylus.sone.web.pages.LoggedInPage;
import net.pterodactylus.util.template.TemplateContext;
import org.jetbrains.annotations.NotNull;

@TemplatePath(value="/templates/createAlbum.html")
@ToadletPath(value="createAlbum.html")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lnet/pterodactylus/sone/web/pages/CreateAlbumPage;", "Lnet/pterodactylus/sone/web/pages/LoggedInPage;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "(Lnet/pterodactylus/sone/web/WebInterface;Lnet/pterodactylus/sone/main/Loaders;Lnet/pterodactylus/sone/web/page/TemplateRenderer;)V", "handleRequest", "", "soneRequest", "Lnet/pterodactylus/sone/web/page/SoneRequest;", "currentSone", "Lnet/pterodactylus/sone/data/Sone;", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "Sone"})
public final class CreateAlbumPage
extends LoggedInPage {
    @Override
    protected void handleRequest(@NotNull SoneRequest soneRequest, @NotNull Sone currentSone, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(soneRequest, "soneRequest");
        Intrinsics.checkParameterIsNotNull(currentSone, "currentSone");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
        if (RequestsKt.isPOST(soneRequest)) {
            String string = soneRequest.getHttpRequest().getPartAsStringFailsafe("name", 64);
            Intrinsics.checkExpressionValueIsNotNull(string, "soneRequest.httpRequest.\u2026tringFailsafe(\"name\", 64)");
            CharSequence charSequence = string;
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String name = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            charSequence = name;
            bl = false;
            if (charSequence.length() == 0) {
                templateContext.set("nameMissing", true);
                return;
            }
            String string3 = soneRequest.getHttpRequest().getPartAsStringFailsafe("description", 256);
            Intrinsics.checkExpressionValueIsNotNull(string3, "soneRequest.httpRequest.\u2026lsafe(\"description\", 256)");
            String string4 = string3;
            boolean bl2 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String description = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            String parentId = soneRequest.getHttpRequest().getPartAsStringFailsafe("parent", 36);
            Album parent = Intrinsics.areEqual(parentId, "") ? currentSone.getRootAlbum() : soneRequest.getCore().getAlbum(parentId);
            Album album = soneRequest.getCore().createAlbum(currentSone, parent);
            try {
                Album.Modifier modifier = album.modify();
                boolean bl3 = false;
                boolean bl4 = false;
                Album.Modifier $this$apply = modifier;
                boolean bl5 = false;
                $this$apply.setTitle(name);
                $this$apply.setDescription(TextFilter.filter(soneRequest.getHttpRequest().getHeader("Host"), description));
                modifier.update();
            }
            catch (Album.Modifier.AlbumTitleMustNotBeEmpty e) {
                Void void_ = this.redirectTo("emptyAlbumTitle.html");
                throw null;
            }
            soneRequest.getCore().touchConfiguration();
            Void void_ = this.redirectTo("imageBrowser.html?album=" + album.getId());
            throw null;
        }
    }

    @Inject
    public CreateAlbumPage(@NotNull WebInterface webInterface, @NotNull Loaders loaders, @NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
        super("Page.CreateAlbum.Title", webInterface, loaders, templateRenderer);
    }
}

