/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.pages;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.text.TextFilter;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.page.SoneRequest;
import net.pterodactylus.sone.web.page.TemplatePath;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.page.ToadletPath;
import net.pterodactylus.sone.web.pages.LoggedInPage;
import net.pterodactylus.util.template.TemplateContext;
import org.jetbrains.annotations.NotNull;

@TemplatePath(value="/templates/createPost.html")
@ToadletPath(value="createPost.html")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lnet/pterodactylus/sone/web/pages/CreatePostPage;", "Lnet/pterodactylus/sone/web/pages/LoggedInPage;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "(Lnet/pterodactylus/sone/web/WebInterface;Lnet/pterodactylus/sone/main/Loaders;Lnet/pterodactylus/sone/web/page/TemplateRenderer;)V", "handleRequest", "", "soneRequest", "Lnet/pterodactylus/sone/web/page/SoneRequest;", "currentSone", "Lnet/pterodactylus/sone/data/Sone;", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "Sone"})
public final class CreatePostPage
extends LoggedInPage {
    @Override
    protected void handleRequest(@NotNull SoneRequest soneRequest, @NotNull Sone currentSone, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(soneRequest, "soneRequest");
        Intrinsics.checkParameterIsNotNull(currentSone, "currentSone");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
        String returnPage = soneRequest.getHttpRequest().getPartAsStringFailsafe("returnPage", 256);
        templateContext.set("returnPage", returnPage);
        if (RequestsKt.isPOST(soneRequest)) {
            String string = soneRequest.getHttpRequest().getPartAsStringFailsafe("text", 65536);
            Intrinsics.checkExpressionValueIsNotNull(string, "soneRequest.httpRequest.\u2026ngFailsafe(\"text\", 65536)");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String text = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (Intrinsics.areEqual(text, "")) {
                templateContext.set("errorTextEmpty", true);
                return;
            }
            Sone sone = soneRequest.getCore().getLocalSone(soneRequest.getHttpRequest().getPartAsStringFailsafe("sender", 43));
            if (sone == null) {
                sone = currentSone;
            }
            Sone sender = sone;
            Sone recipient = soneRequest.getCore().getSone(soneRequest.getHttpRequest().getPartAsStringFailsafe("recipient", 43));
            soneRequest.getCore().createPost(sender, recipient, TextFilter.filter(soneRequest.getHttpRequest().getHeader("Host"), text));
            Void void_ = this.redirectTo(returnPage);
            throw null;
        }
    }

    @Inject
    public CreatePostPage(@NotNull WebInterface webInterface, @NotNull Loaders loaders, @NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
        super("Page.CreatePost.Title", webInterface, loaders, templateRenderer);
    }
}

