/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.pages;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.SoneKt;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.utils.Pagination;
import net.pterodactylus.sone.utils.PaginationKt;
import net.pterodactylus.sone.utils.Parameters;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.page.MenuName;
import net.pterodactylus.sone.web.page.SoneRequest;
import net.pterodactylus.sone.web.page.TemplatePath;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.page.ToadletPath;
import net.pterodactylus.sone.web.pages.LoggedInPage;
import net.pterodactylus.util.template.TemplateContext;
import org.jetbrains.annotations.NotNull;

@MenuName(value="ImageBrowser")
@TemplatePath(value="/templates/imageBrowser.html")
@ToadletPath(value="imageBrowser.html")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lnet/pterodactylus/sone/web/pages/ImageBrowserPage;", "Lnet/pterodactylus/sone/web/pages/LoggedInPage;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "(Lnet/pterodactylus/sone/web/WebInterface;Lnet/pterodactylus/sone/main/Loaders;Lnet/pterodactylus/sone/web/page/TemplateRenderer;)V", "handleRequest", "", "soneRequest", "Lnet/pterodactylus/sone/web/page/SoneRequest;", "currentSone", "Lnet/pterodactylus/sone/data/Sone;", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "isLinkExcepted", "", "link", "Ljava/net/URI;", "Sone"})
public final class ImageBrowserPage
extends LoggedInPage {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleRequest(@NotNull SoneRequest soneRequest, @NotNull Sone currentSone, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(soneRequest, "soneRequest");
        Intrinsics.checkParameterIsNotNull(currentSone, "currentSone");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
        if (RequestsKt.getParameters(soneRequest).contains("album")) {
            templateContext.set("albumRequested", true);
            Core core = soneRequest.getCore();
            String string = Parameters.get$default(RequestsKt.getParameters(soneRequest), "album", 0, 2, null);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            templateContext.set("album", core.getAlbum(string));
            templateContext.set("page", Parameters.get$default(RequestsKt.getParameters(soneRequest), "page", 0, 2, null));
        } else if (RequestsKt.getParameters(soneRequest).contains("image")) {
            templateContext.set("imageRequested", true);
            templateContext.set("image", soneRequest.getCore().getImage(Parameters.get$default(RequestsKt.getParameters(soneRequest), "image", 0, 2, null)));
        } else if (Intrinsics.areEqual(Parameters.get$default(RequestsKt.getParameters(soneRequest), "mode", 0, 2, null), "gallery")) {
            Object object;
            void $this$filterNotTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            templateContext.set("galleryRequested", true);
            Collection<Sone> collection = soneRequest.getCore().getSones();
            Intrinsics.checkExpressionValueIsNotNull(collection, "soneRequest.core.sones");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Object object2 = $this$flatMapTo$iv$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = object2.next();
                boolean bl = false;
                Iterable list$iv$iv = SoneKt.getAllAlbums((Sone)receiver);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$flatMapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo22 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Album p1 = (Album)element$iv$iv;
                boolean bl = false;
                if (p1.isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            iterable = $this$sortedBy$iv;
            boolean destination$iv$iv2 = false;
            Comparator $i$f$filterNotTo22 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Album p1 = (Album)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)p1.getTitle());
                    p1 = (Album)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = p1.getTitle();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
                }
            };
            List list = CollectionsKt.sortedWith(iterable, $i$f$filterNotTo22);
            boolean bl = false;
            boolean bl2 = false;
            List albums = list;
            boolean bl3 = false;
            object2 = PaginationKt.paginate(albums, soneRequest.getCore().getPreferences().getImagesPerPage()).turnTo((object = Parameters.get$default(RequestsKt.getParameters(soneRequest), "page", 0, 2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0);
            boolean bl4 = false;
            boolean bl5 = false;
            Object pagination = object2;
            boolean bl6 = false;
            templateContext.set("albumPagination", pagination);
            templateContext.set("albums", ((Pagination)pagination).getItems());
        } else {
            templateContext.set("soneRequested", true);
            Sone sone = soneRequest.getCore().getSone(soneRequest.getHttpRequest().getParam("sone"));
            if (sone == null) {
                sone = currentSone;
            }
            templateContext.set("sone", sone);
        }
    }

    @Override
    public boolean isLinkExcepted(@NotNull URI link) {
        Intrinsics.checkParameterIsNotNull(link, "link");
        return true;
    }

    @Inject
    public ImageBrowserPage(@NotNull WebInterface webInterface, @NotNull Loaders loaders, @NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
        super("Page.ImageBrowser.Title", webInterface, loaders, templateRenderer);
    }
}

