/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.sone.web.pages;

import freenet.support.api.Bucket;
import freenet.support.api.HTTPUploadedFile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import net.pterodactylus.sone.core.Core;
import net.pterodactylus.sone.data.Album;
import net.pterodactylus.sone.data.Image;
import net.pterodactylus.sone.data.Sone;
import net.pterodactylus.sone.data.TemporaryImage;
import net.pterodactylus.sone.main.Loaders;
import net.pterodactylus.sone.text.TextFilter;
import net.pterodactylus.sone.utils.BucketsKt;
import net.pterodactylus.sone.utils.Parameters;
import net.pterodactylus.sone.utils.RequestsKt;
import net.pterodactylus.sone.utils.StringsKt;
import net.pterodactylus.sone.web.WebInterface;
import net.pterodactylus.sone.web.page.SoneRequest;
import net.pterodactylus.sone.web.page.TemplatePath;
import net.pterodactylus.sone.web.page.TemplateRenderer;
import net.pterodactylus.sone.web.page.ToadletPath;
import net.pterodactylus.sone.web.pages.LoggedInPage;
import net.pterodactylus.util.template.TemplateContext;
import org.jetbrains.annotations.NotNull;

@TemplatePath(value="/templates/invalid.html")
@ToadletPath(value="uploadImage.html")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\f\u0010\u0016\u001a\u00020\u000b*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u000bH\u0002R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lnet/pterodactylus/sone/web/pages/UploadImagePage;", "Lnet/pterodactylus/sone/web/pages/LoggedInPage;", "webInterface", "Lnet/pterodactylus/sone/web/WebInterface;", "loaders", "Lnet/pterodactylus/sone/main/Loaders;", "templateRenderer", "Lnet/pterodactylus/sone/web/page/TemplateRenderer;", "(Lnet/pterodactylus/sone/web/WebInterface;Lnet/pterodactylus/sone/main/Loaders;Lnet/pterodactylus/sone/web/page/TemplateRenderer;)V", "mimeType", "", "", "getMimeType", "([B)Ljava/lang/String;", "handleRequest", "", "soneRequest", "Lnet/pterodactylus/sone/web/page/SoneRequest;", "currentSone", "Lnet/pterodactylus/sone/data/Sone;", "templateContext", "Lnet/pterodactylus/util/template/TemplateContext;", "toByteArray", "Lfreenet/support/api/Bucket;", "toImage", "Ljava/awt/image/BufferedImage;", "Sone"})
public final class UploadImagePage
extends LoggedInPage {
    @Override
    protected void handleRequest(@NotNull SoneRequest soneRequest, @NotNull Sone currentSone, @NotNull TemplateContext templateContext) {
        Intrinsics.checkParameterIsNotNull(soneRequest, "soneRequest");
        Intrinsics.checkParameterIsNotNull(currentSone, "currentSone");
        Intrinsics.checkParameterIsNotNull(templateContext, "templateContext");
        if (RequestsKt.isPOST(soneRequest)) {
            HTTPUploadedFile uploadedFile;
            String string = Parameters.get$default(RequestsKt.getParameters(soneRequest), "parent", 0, 2, null);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            Core core = soneRequest.getCore();
            boolean bl = false;
            boolean bl2 = false;
            String p1 = string2;
            boolean bl3 = false;
            Album album = core.getAlbum(p1);
            if (album == null) {
                Void void_ = this.redirectTo("noPermission.html");
                throw null;
            }
            Intrinsics.checkExpressionValueIsNotNull(album, "soneRequest.parameters[\"\u2026ctTo(\"noPermission.html\")");
            Album parentAlbum = album;
            if (Intrinsics.areEqual(parentAlbum.getSone(), currentSone) ^ true) {
                Void void_ = this.redirectTo("noPermission.html");
                throw null;
            }
            String string3 = StringsKt.getEmptyToNull(RequestsKt.getParameters(soneRequest).get("title", 200));
            if (string3 == null) {
                Void void_ = this.redirectTo("emptyImageTitle.html");
                throw null;
            }
            String title = string3;
            HTTPUploadedFile hTTPUploadedFile = uploadedFile = soneRequest.getHttpRequest().getUploadedFile("image");
            Intrinsics.checkExpressionValueIsNotNull(hTTPUploadedFile, "uploadedFile");
            Bucket bucket = hTTPUploadedFile.getData();
            Intrinsics.checkExpressionValueIsNotNull(bucket, "uploadedFile.data");
            byte[] bytes2 = (byte[])BucketsKt.use(bucket, (Function1)new Function1<Bucket, byte[]>(this){
                final /* synthetic */ UploadImagePage this$0;

                @NotNull
                public final byte[] invoke(@NotNull Bucket it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return UploadImagePage.access$toByteArray(this.this$0, it);
                }
                {
                    this.this$0 = uploadImagePage;
                    super(1);
                }
            });
            BufferedImage bufferedImage = this.toImage(bytes2);
            if (bufferedImage == null) {
                templateContext.set("messages", this.getTranslation().translate("Page.UploadImage.Error.InvalidImage"));
                return;
            }
            TemporaryImage temporaryImage = soneRequest.getCore().createTemporaryImage(this.getMimeType(bytes2), bytes2);
            Image.Modifier modifier = soneRequest.getCore().createImage(currentSone, parentAlbum, temporaryImage).modify();
            boolean bl4 = false;
            boolean bl5 = false;
            Image.Modifier $this$apply = modifier;
            boolean bl6 = false;
            $this$apply.setWidth(bufferedImage.getWidth());
            $this$apply.setHeight(bufferedImage.getHeight());
            $this$apply.setTitle(title);
            $this$apply.setDescription(TextFilter.filter(RequestsKt.getHeaders(soneRequest).get("Host"), RequestsKt.getParameters(soneRequest).get("description", 4000)));
            modifier.update();
            Void void_ = this.redirectTo("imageBrowser.html?album=" + parentAlbum.getId());
            throw null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] toByteArray(@NotNull Bucket $this$toByteArray) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream((int)$this$toByteArray.size());
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            InputStream inputStream = $this$toByteArray.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "inputStream");
            ByteStreamsKt.copyTo$default(inputStream, outputStream, 0, 2, null);
            byte[] byArray2 = outputStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "outputStream.toByteArray()");
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull(byArray, "ByteArrayOutputStream(si\u2026utStream.toByteArray()\n\t}");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage toImage(@NotNull byte[] $this$toImage) {
        BufferedImage bufferedImage;
        Closeable closeable = new ByteArrayInputStream($this$toImage);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl2 = false;
            bufferedImage = ImageIO.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getMimeType(@NotNull byte[] $this$mimeType) {
        String[] stringArray;
        Closeable closeable = new ByteArrayInputStream($this$mimeType);
        boolean bl = false;
        Throwable throwable = null;
        try {
            String[] stringArray2;
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = ImageIO.createImageInputStream(it);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                ImageInputStream it2 = (ImageInputStream)closeable2;
                boolean bl4 = false;
                Iterator<ImageReader> iterator2 = ImageIO.getImageReaders(it2);
                Intrinsics.checkExpressionValueIsNotNull(iterator2, "ImageIO.getImageReaders(it)");
                Object object = SequencesKt.firstOrNull(SequencesKt.asSequence(iterator2));
                if (object == null || (object = object.getOriginatingProvider()) == null || (object = object.getMIMETypes()) == null || (object = ArraysKt.firstOrNull(object)) == null) {
                    object = "application/octet-stream";
                }
                stringArray2 = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            stringArray = stringArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return stringArray;
    }

    @Inject
    public UploadImagePage(@NotNull WebInterface webInterface, @NotNull Loaders loaders, @NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkParameterIsNotNull(webInterface, "webInterface");
        Intrinsics.checkParameterIsNotNull(loaders, "loaders");
        Intrinsics.checkParameterIsNotNull(templateRenderer, "templateRenderer");
        super("Page.UploadImage.Title", webInterface, loaders, templateRenderer);
    }

    public static final /* synthetic */ byte[] access$toByteArray(UploadImagePage $this, Bucket $this$access_u24toByteArray) {
        return $this.toByteArray($this$access_u24toByteArray);
    }
}

