/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBean {
    private final List<PropertyChangeListener> propertyChangeListeners = Collections.synchronizedList(new ArrayList());

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, property, oldValue, newValue);
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    protected void fireIfPropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (!this.equal(oldValue, newValue)) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private boolean equal(Object first2, Object second) {
        return first2 == null && second == null || first2 != null && first2.equals(second) || second.equals(first2);
    }
}

