/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.pterodactylus.util.collection.filter.Filter;
import net.pterodactylus.util.collection.mapper.Mapper;
import net.pterodactylus.util.collection.processor.Processor;
import net.pterodactylus.util.validation.Validation;

public class Container<T>
implements Iterable<T> {
    private final Object[] elements;

    public Container() {
        this.elements = new Object[0];
    }

    public Container(T element) {
        this.elements = new Object[]{element};
    }

    public Container(T[] elements) {
        Validation.begin().isNotNull("Elements", elements).check();
        this.elements = new Object[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
    }

    public Container(Collection<? extends T> elements) {
        Validation.begin().isNotNull("Elements", elements).check();
        this.elements = elements.toArray();
    }

    public Container(Iterable<? extends T> elements) {
        this(elements.iterator());
    }

    public Container(Iterator<? extends T> elementIterator) {
        ArrayList<T> elements = new ArrayList<T>();
        while (elementIterator.hasNext()) {
            elements.add(elementIterator.next());
        }
        this.elements = elements.toArray();
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public T get() {
        return this.get(null);
    }

    public T get(T defaultValue) {
        if (this.elements.length == 0) {
            return defaultValue;
        }
        return (T)this.elements[0];
    }

    public Container<T> last() {
        if (this.elements.length < 2) {
            return this;
        }
        return this.crop(this.elements.length - 1, this.elements.length);
    }

    public int indexOf(T element) {
        for (int index = 0; index < this.elements.length; ++index) {
            if ((element != null || this.elements[index] != null) && (element == null || !element.equals(this.elements[index]))) continue;
            return index;
        }
        return -1;
    }

    public boolean contains(T element) {
        return this.indexOf(element) != -1;
    }

    public Container<T> add(T element) {
        return this.add(this.elements.length, element);
    }

    public Container<T> add(int index, T element) {
        Validation.begin().isGreaterOrEqual("Index", index, 0L).isLessOrEqual("Index", index, this.elements.length).check();
        Object[] newElements = new Object[this.elements.length + 1];
        System.arraycopy(this.elements, 0, newElements, 0, index);
        newElements[index] = element;
        System.arraycopy(this.elements, index, newElements, index + 1, this.elements.length - index);
        return new Container<Object>(newElements);
    }

    public Container<T> crop(int index) {
        return this.crop(index, index + 1);
    }

    public Container<T> crop(int start2, int end) {
        Validation.begin().isGreaterOrEqual("Start Index", start2, 0L).isGreaterOrEqual("End Index", end, 0L).isLessOrEqual("Start Index", start2, this.elements.length - 1).isLessOrEqual("End Index", end, this.elements.length).isGreaterOrEqual("End Index", end, start2).check();
        if (end - start2 == 0) {
            return new Container<T>();
        }
        if (start2 == 0 && end == this.elements.length) {
            return this;
        }
        if (end - start2 == 1) {
            return new Container<Object>(this.elements[start2]);
        }
        Object[] newElements = new Object[end - start2];
        System.arraycopy(this.elements, start2, newElements, 0, end - start2);
        return new Container<Object>(newElements);
    }

    public Container<T> remove(T element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return this;
        }
        return this.remove(index);
    }

    public Container<T> remove(int index) {
        Validation.begin().isGreaterOrEqual("Index", index, 0L).isLessOrEqual("Index", index, this.elements.length - 1).check();
        if (this.elements.length == 1) {
            return new Container<T>();
        }
        Object[] newElements = new Object[this.elements.length - 1];
        System.arraycopy(this.elements, 0, newElements, 0, index);
        System.arraycopy(this.elements, index + 1, newElements, index, newElements.length - index);
        return new Container<Object[]>(newElements);
    }

    public Container<T> reverse() {
        if (this.elements.length < 2) {
            return this;
        }
        Object[] newElements = new Object[this.elements.length];
        int newIndex = 0;
        for (int oldIndex = this.elements.length; oldIndex >= 0; --oldIndex) {
            newElements[newIndex] = this.elements[oldIndex];
            ++newIndex;
        }
        return new Container<Object>(newElements);
    }

    public Container<T> sort() {
        return this.sort(null);
    }

    public Container<T> sort(Comparator<? super T> comparator) {
        if (this.elements.length < 2) {
            return this;
        }
        Object[] newElements = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
        Arrays.sort(newElements, comparator);
        return new Container<Object>(newElements);
    }

    public Container<T> filter(Filter<T> filter2) {
        Object[] filteredElements = new Object[this.elements.length];
        int filteredElementCount = 0;
        for (Object object : this.elements) {
            if (!filter2.filterObject(object)) continue;
            filteredElements[filteredElementCount++] = object;
        }
        if (filteredElementCount == this.elements.length) {
            return this;
        }
        if (filteredElementCount == 0) {
            return new Container<T>();
        }
        Object[] finalElements = new Object[filteredElementCount];
        System.arraycopy(filteredElements, 0, finalElements, 0, filteredElementCount);
        return new Container<Object>(finalElements);
    }

    public <O> Container<O> map(Mapper<T, O> mapper) {
        if (this.isEmpty()) {
            return this;
        }
        Object[] mappedElements = new Object[this.elements.length];
        int index = 0;
        for (Object object : this.elements) {
            mappedElements[index++] = mapper.map(object);
        }
        return new Container<Object>(mappedElements);
    }

    public <O> Container<O> map(Map<T, O> map2) {
        if (this.isEmpty()) {
            return this;
        }
        Object[] mappedElements = new Object[this.elements.length];
        int index = 0;
        for (Object object : this.elements) {
            mappedElements[index++] = map2.get(object);
        }
        return new Container<Object>(mappedElements);
    }

    public Container<T> process(Processor<T> processor) {
        for (Object object : this.elements) {
            processor.process(object);
        }
        return this;
    }

    public List<T> asList() {
        return Arrays.asList(this.elements);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Container.this.elements.length;
            }

            @Override
            public T next() {
                return Container.this.elements[this.index++];
            }

            @Override
            public void remove() {
            }
        };
    }
}

