/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.pterodactylus.util.collection.filter.Filter;
import net.pterodactylus.util.collection.filter.FilteredIterable;
import net.pterodactylus.util.collection.mapper.MappedIterable;
import net.pterodactylus.util.collection.mapper.Mapper;
import net.pterodactylus.util.collection.processor.ProcessedIterable;
import net.pterodactylus.util.collection.processor.Processor;

public class IterableWrapper<T>
implements Iterable<T> {
    private final Iterable<T> iterable;

    public IterableWrapper(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public IterableWrapper<T> filter(Filter<? super T> filter2) {
        return new IterableWrapper<T>(new FilteredIterable<T>(this.iterable, filter2));
    }

    public <O> IterableWrapper<O> map(Mapper<? super T, ? extends O> mapper) {
        return new IterableWrapper<T>(new MappedIterable<T, O>(this.iterable, mapper));
    }

    public IterableWrapper<T> process(Processor<? super T> processor) {
        return new IterableWrapper<T>(new ProcessedIterable<T>(this.iterable, processor));
    }

    public boolean isEmpty() {
        return !this.iterable.iterator().hasNext();
    }

    public T get() throws NoSuchElementException {
        Iterator<T> iterator2 = this.iterable.iterator();
        if (iterator2.hasNext()) {
            return iterator2.next();
        }
        throw new NoSuchElementException();
    }

    public T get(T defaultValue) {
        Iterator<T> iterator2 = this.iterable.iterator();
        return iterator2.hasNext() ? iterator2.next() : defaultValue;
    }

    public Collection<T> collection() {
        ArrayList<T> collection = new ArrayList<T>();
        for (T object : this.iterable) {
            collection.add(object);
        }
        return collection;
    }

    public List<T> list() {
        return (List)this.collection();
    }

    public static <T> IterableWrapper<T> emptyIterable() {
        return new IterableWrapper<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public T next() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        });
    }

    public static <T> IterableWrapper<T> wrap(Iterable<T> iterable) {
        return new IterableWrapper<T>(iterable);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }
}

