/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TimedMap<K, V>
implements Map<K, V> {
    private final Map<K, TimedItem<V>> storage = new HashMap<K, TimedItem<V>>();
    private final long maximumAge;

    public TimedMap() {
        this(60000L);
    }

    public TimedMap(long maximumAge) {
        this.maximumAge = maximumAge;
    }

    public TimedMap(Map<K, V> original) {
        this(60000L, original);
    }

    public TimedMap(long maximumAge, Map<K, V> original) {
        this(maximumAge);
        for (Map.Entry<K, V> originalEntry : original.entrySet()) {
            this.storage.put(originalEntry.getKey(), new TimedItem<V>(originalEntry.getValue()));
        }
    }

    @Override
    public int size() {
        this.checkForExpiredValues();
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkForExpiredValues();
        return this.storage.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkForExpiredValues();
        return this.storage.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkForExpiredValues();
        for (Map.Entry<K, TimedItem<V>> entry : this.storage.entrySet()) {
            if ((value != null || entry.getValue().getItem() != null) && (value == null || !value.equals(entry.getValue().getItem()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.checkForExpiredValues();
        TimedItem<V> item = this.storage.get(key);
        return item != null ? (V)item.getItem() : null;
    }

    @Override
    public V put(K key, V value) {
        this.checkForExpiredValues();
        TimedItem<V> oldItem = this.storage.get(key);
        this.storage.put(key, new TimedItem<V>(value));
        return oldItem != null ? (V)oldItem.getItem() : null;
    }

    @Override
    public V remove(Object key) {
        this.checkForExpiredValues();
        TimedItem<V> removedItem = this.storage.remove(key);
        return removedItem != null ? (V)removedItem.getItem() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this.checkForExpiredValues();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public Set<K> keySet() {
        this.checkForExpiredValues();
        return this.storage.keySet();
    }

    @Override
    public Collection<V> values() {
        this.checkForExpiredValues();
        ArrayList<V> values2 = new ArrayList<V>();
        for (TimedItem<V> value : this.storage.values()) {
            values2.add(value.getItem());
        }
        return values2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkForExpiredValues();
        HashSet<Map.Entry<K, V>> resultSet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, TimedItem<V>> entry : this.storage.entrySet()) {
            resultSet.add(new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue().getItem()));
        }
        return resultSet;
    }

    private void checkForExpiredValues() {
        long maximumTime = System.currentTimeMillis() - this.maximumAge;
        Iterator<Map.Entry<K, TimedItem<V>>> entryIterator = this.storage.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<K, TimedItem<V>> entry = entryIterator.next();
            if (entry.getValue().getTimestamp() >= maximumTime) continue;
            entryIterator.remove();
        }
    }

    private static class TimedItem<V> {
        private final long timestamp;
        private final V item;

        public TimedItem(V item) {
            this(System.currentTimeMillis(), item);
        }

        public TimedItem(long timestamp, V item) {
            this.timestamp = timestamp;
            this.item = item;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public V getItem() {
            return this.item;
        }
    }
}

