/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.pterodactylus.util.collection.filter.Filter;

public class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Filter<? super T> filter;
    private boolean checked;
    private boolean hasNext;
    private T next;

    public FilteredIterator(Iterator<T> iterator2, Filter<? super T> filter2) {
        this.iterator = iterator2;
        this.filter = filter2;
    }

    private void getNext() {
        if (this.checked) {
            return;
        }
        this.hasNext = false;
        while (this.iterator.hasNext()) {
            this.next = this.iterator.next();
            if (!this.filter.filterObject(this.next)) continue;
            this.hasNext = true;
            break;
        }
        this.checked = true;
    }

    @Override
    public boolean hasNext() {
        this.getNext();
        return this.hasNext;
    }

    @Override
    public T next() {
        this.getNext();
        this.checked = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

