/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pterodactylus.util.collection.filter.Filter;
import net.pterodactylus.util.collection.filter.FilteredIterator;

public class Filters {
    public static <E> List<E> filteredList(List<E> list, Filter<? super E> listFilter) {
        ArrayList<E> filteredList = new ArrayList<E>();
        for (E element : list) {
            if (!listFilter.filterObject(element)) continue;
            filteredList.add(element);
        }
        return filteredList;
    }

    public static <E> Set<E> filteredSet(Set<E> set, Filter<? super E> setFilter) {
        HashSet<E> filteredSet = new HashSet<E>();
        for (E element : set) {
            if (!setFilter.filterObject(element)) continue;
            filteredSet.add(element);
        }
        return filteredSet;
    }

    public static <K, V> Map<K, V> filteredMap(Map<K, V> map2, Filter<Map.Entry<K, V>> mapFilter) {
        HashMap<K, V> filteredMap = new HashMap<K, V>();
        for (Map.Entry<K, V> element : map2.entrySet()) {
            if (!mapFilter.filterObject(element)) continue;
            filteredMap.put(element.getKey(), element.getValue());
        }
        return filteredMap;
    }

    public static <K> Collection<K> filteredCollection(Collection<K> collection, Filter<? super K> collectionFilter) {
        return Filters.filteredList(new ArrayList<K>(collection), collectionFilter);
    }

    public static <E> Iterator<E> filteredIterator(Iterator<E> iterator2, Filter<? super E> iteratorFilter) {
        return new FilteredIterator<E>(iterator2, iteratorFilter);
    }

    public static <E> Filter<E> reverseFilter(final Filter<E> filter2) {
        return new Filter<E>(){

            @Override
            public boolean filterObject(E object) {
                return !filter2.filterObject(object);
            }
        };
    }
}

