/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.database.ObjectCreator;

public class MapCreator
implements ObjectCreator<Map<String, Object>> {
    @Override
    public Map<String, Object> createObject(ResultSet resultSet) throws SQLException {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        for (int column = 1; column <= metadata.getColumnCount(); ++column) {
            int columnType = metadata.getColumnType(column);
            String columnLabel = metadata.getColumnLabel(column);
            if (columnType == 4) {
                result2.put(columnLabel, resultSet.getInt(column));
                continue;
            }
            if (columnType == -5) {
                result2.put(columnLabel, resultSet.getLong(column));
                continue;
            }
            if (columnType == 3) {
                result2.put(columnLabel, resultSet.getDouble(column));
                continue;
            }
            if (columnType == 16) {
                result2.put(columnLabel, resultSet.getBoolean(column));
                continue;
            }
            if (columnType == 12) {
                result2.put(columnLabel, resultSet.getString(column));
                continue;
            }
            if (columnType == -1) {
                result2.put(columnLabel, resultSet.getString(column));
                continue;
            }
            if (columnType == 91) {
                result2.put(columnLabel, resultSet.getDate(column));
                continue;
            }
            System.out.println("unknown type (" + columnType + ") for column \u201c" + columnLabel + "\u201d.");
        }
        return result2;
    }
}

