/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.i18n.gui;

import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import net.pterodactylus.util.i18n.I18n;
import net.pterodactylus.util.i18n.I18nable;
import net.pterodactylus.util.i18n.gui.I18nAction;

public class I18nMenuItem
extends MenuItem
implements I18nable {
    private final I18n i18n;
    private final String i18nBasename;
    private final Action action;

    public I18nMenuItem(I18n i18n, String i18nBasename) {
        this(i18n, null, i18nBasename);
    }

    public I18nMenuItem(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename) {
        this(i18n, removalReference, i18nBasename, null);
    }

    public I18nMenuItem(I18n i18n, String i18nBasename, Action action) {
        this(i18n, null, i18nBasename, action);
    }

    public I18nMenuItem(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename, final Action action) {
        this.i18n = i18n;
        this.i18nBasename = i18nBasename;
        i18n.addI18nable(this, removalReference);
        this.action = action;
        if (action != null) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(actionEvent);
                }
            });
            action.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        I18nMenuItem.this.updateI18n();
                    }
                }
            });
        }
        this.updateI18n();
    }

    public I18nMenuItem(I18n i18n, I18nAction i18nAction) {
        this(i18n, (I18n.RemovalReference)null, i18nAction);
    }

    public I18nMenuItem(I18n i18n, I18n.RemovalReference removalReference, I18nAction i18nAction) {
        this(i18n, removalReference, i18nAction.getI18nBasename(), i18nAction);
    }

    @Override
    public void updateI18n() {
        this.setLabel(this.i18n.get(this.i18nBasename + ".name", new Object[0]));
        this.setShortcut(new MenuShortcut(this.i18n.getKey(this.i18nBasename + ".mnemonic"), false));
        if (this.action != null) {
            this.setEnabled(this.action.isEnabled());
        }
    }
}

