/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pterodactylus.util.number.Bits;

public class BitShiftedInputStream
extends FilterInputStream {
    protected int valueSize;
    protected int currentBitPosition;
    protected int currentValue;

    public BitShiftedInputStream(InputStream in, int valueSize) {
        super(in);
        if (valueSize < 1 || valueSize > 32) {
            throw new IllegalArgumentException("valueSize out of range 1-32");
        }
        this.valueSize = valueSize;
        this.currentBitPosition = 8;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.valueSize);
    }

    public int read(int valueSize) throws IOException {
        int value = 0;
        for (int bitsLeft = valueSize; bitsLeft > 0; --bitsLeft) {
            if (this.currentBitPosition > 7) {
                this.currentValue = super.read();
                this.currentBitPosition = 0;
            }
            value = Bits.encodeBits(value, valueSize - bitsLeft, 1, this.currentValue);
            this.currentValue >>>= 1;
            ++this.currentBitPosition;
        }
        return value;
    }

    public void skipBits(int numberOfBits) throws IOException {
        for (int bitsLeft = numberOfBits; bitsLeft > 0; --bitsLeft) {
            if (this.currentBitPosition > 7) {
                this.currentValue = super.read();
                this.currentBitPosition = 0;
            }
            this.currentValue >>>= 1;
            ++this.currentBitPosition;
        }
    }
}

