/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MimeTypes {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final List<String> mimeTypes = new ArrayList<String>();
    private static final Map<String, List<String>> mimeTypeExtensions = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> extensionMimeTypes = new HashMap<String, List<String>>();

    public static List<String> getAllMimeTypes() {
        return new ArrayList<String>(mimeTypes);
    }

    public static List<String> getMimeTypes(String extension) {
        if (extensionMimeTypes.containsKey(extension)) {
            return extensionMimeTypes.get(extension);
        }
        return Collections.emptyList();
    }

    public static String getMimeType(String extension) {
        if (extensionMimeTypes.containsKey(extension)) {
            return extensionMimeTypes.get(extension).get(0);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private static void addMimeType(String mimeType, String ... extensions) {
        mimeTypes.add(mimeType);
        for (String extension : extensions) {
            if (!mimeTypeExtensions.containsKey(mimeType)) {
                mimeTypeExtensions.put(mimeType, new ArrayList());
            }
            mimeTypeExtensions.get(mimeType).add(extension);
            if (!extensionMimeTypes.containsKey(extension)) {
                extensionMimeTypes.put(extension, new ArrayList());
            }
            extensionMimeTypes.get(extension).add(mimeType);
        }
    }

    static {
        MimeTypes.addMimeType("application/activemessage", new String[0]);
        MimeTypes.addMimeType("application/andrew-inset", "ez");
        MimeTypes.addMimeType("application/applefile", new String[0]);
        MimeTypes.addMimeType("application/atomicmail", new String[0]);
        MimeTypes.addMimeType("application/batch-SMTP", new String[0]);
        MimeTypes.addMimeType("application/beep+xml", new String[0]);
        MimeTypes.addMimeType("application/cals-1840", new String[0]);
        MimeTypes.addMimeType("application/commonground", new String[0]);
        MimeTypes.addMimeType("application/cu-seeme", "cu");
        MimeTypes.addMimeType("application/cybercash", new String[0]);
        MimeTypes.addMimeType("application/dca-rft", new String[0]);
        MimeTypes.addMimeType("application/dec-dx", new String[0]);
        MimeTypes.addMimeType("application/docbook+xml", new String[0]);
        MimeTypes.addMimeType("application/dsptype", "tsp");
        MimeTypes.addMimeType("application/dvcs", new String[0]);
        MimeTypes.addMimeType("application/edi-consent", new String[0]);
        MimeTypes.addMimeType("application/edi-x12", new String[0]);
        MimeTypes.addMimeType("application/edifact", new String[0]);
        MimeTypes.addMimeType("application/eshop", new String[0]);
        MimeTypes.addMimeType("application/font-tdpfr", new String[0]);
        MimeTypes.addMimeType("application/futuresplash", "spl");
        MimeTypes.addMimeType("application/ghostview", new String[0]);
        MimeTypes.addMimeType("application/hta", "hta");
        MimeTypes.addMimeType("application/http", new String[0]);
        MimeTypes.addMimeType("application/hyperstudio", new String[0]);
        MimeTypes.addMimeType("application/iges", new String[0]);
        MimeTypes.addMimeType("application/index", new String[0]);
        MimeTypes.addMimeType("application/index.cmd", new String[0]);
        MimeTypes.addMimeType("application/index.obj", new String[0]);
        MimeTypes.addMimeType("application/index.response", new String[0]);
        MimeTypes.addMimeType("application/index.vnd", new String[0]);
        MimeTypes.addMimeType("application/iotp", new String[0]);
        MimeTypes.addMimeType("application/ipp", new String[0]);
        MimeTypes.addMimeType("application/isup", new String[0]);
        MimeTypes.addMimeType("application/java-archive", "jar");
        MimeTypes.addMimeType("application/java-serialized-object", "ser");
        MimeTypes.addMimeType("application/java-vm", "class");
        MimeTypes.addMimeType("application/mac-binhex40", "hqx");
        MimeTypes.addMimeType("application/mac-compactpro", "cpt");
        MimeTypes.addMimeType("application/macwriteii", new String[0]);
        MimeTypes.addMimeType("application/marc", new String[0]);
        MimeTypes.addMimeType("application/mathematica", "nb");
        MimeTypes.addMimeType("application/mathematica-old", new String[0]);
        MimeTypes.addMimeType("application/msaccess", "mdb");
        MimeTypes.addMimeType("application/msword", "doc", "dot");
        MimeTypes.addMimeType("application/news-message-id", new String[0]);
        MimeTypes.addMimeType("application/news-transmission", new String[0]);
        MimeTypes.addMimeType("application/ocsp-request", new String[0]);
        MimeTypes.addMimeType("application/ocsp-response", new String[0]);
        MimeTypes.addMimeType(DEFAULT_CONTENT_TYPE, "bin");
        MimeTypes.addMimeType("application/oda", "oda");
        MimeTypes.addMimeType("application/ogg", "ogg");
        MimeTypes.addMimeType("application/parityfec", new String[0]);
        MimeTypes.addMimeType("application/pdf", "pdf");
        MimeTypes.addMimeType("application/pgp-encrypted", new String[0]);
        MimeTypes.addMimeType("application/pgp-keys", "key");
        MimeTypes.addMimeType("application/pgp-signature", "pgp");
        MimeTypes.addMimeType("application/pics-rules", "prf");
        MimeTypes.addMimeType("application/pkcs10", new String[0]);
        MimeTypes.addMimeType("application/pkcs7-mime", new String[0]);
        MimeTypes.addMimeType("application/pkcs7-signature", new String[0]);
        MimeTypes.addMimeType("application/pkix-cert", new String[0]);
        MimeTypes.addMimeType("application/pkix-crl", new String[0]);
        MimeTypes.addMimeType("application/pkixcmp", new String[0]);
        MimeTypes.addMimeType("application/postscript", "ps", "ai", "eps");
        MimeTypes.addMimeType("application/prs.alvestrand.titrax-sheet", new String[0]);
        MimeTypes.addMimeType("application/prs.cww", new String[0]);
        MimeTypes.addMimeType("application/prs.nprend", new String[0]);
        MimeTypes.addMimeType("application/qsig", new String[0]);
        MimeTypes.addMimeType("application/rar", "rar");
        MimeTypes.addMimeType("application/rdf+xml", "rdf");
        MimeTypes.addMimeType("application/remote-printing", new String[0]);
        MimeTypes.addMimeType("application/riscos", new String[0]);
        MimeTypes.addMimeType("application/rss+xml", "rss");
        MimeTypes.addMimeType("application/rtf", new String[0]);
        MimeTypes.addMimeType("application/sdp", new String[0]);
        MimeTypes.addMimeType("application/set-payment", new String[0]);
        MimeTypes.addMimeType("application/set-payment-initiation", new String[0]);
        MimeTypes.addMimeType("application/set-registration", new String[0]);
        MimeTypes.addMimeType("application/set-registration-initiation", new String[0]);
        MimeTypes.addMimeType("application/sgml", new String[0]);
        MimeTypes.addMimeType("application/sgml-open-catalog", new String[0]);
        MimeTypes.addMimeType("application/sieve", new String[0]);
        MimeTypes.addMimeType("application/slate", new String[0]);
        MimeTypes.addMimeType("application/smil", "smi", "smil");
        MimeTypes.addMimeType("application/timestamp-query", new String[0]);
        MimeTypes.addMimeType("application/timestamp-reply", new String[0]);
        MimeTypes.addMimeType("application/vemmi", new String[0]);
        MimeTypes.addMimeType("application/whoispp-query", new String[0]);
        MimeTypes.addMimeType("application/whoispp-response", new String[0]);
        MimeTypes.addMimeType("application/wita", new String[0]);
        MimeTypes.addMimeType("application/wordperfect", "wpd");
        MimeTypes.addMimeType("application/wordperfect5.1", "wp5");
        MimeTypes.addMimeType("application/x400-bp", new String[0]);
        MimeTypes.addMimeType("application/xhtml+xml", "xhtml", "xht");
        MimeTypes.addMimeType("application/xml", "xml", "xsl");
        MimeTypes.addMimeType("application/xml-dtd", new String[0]);
        MimeTypes.addMimeType("application/xml-external-parsed-entity", new String[0]);
        MimeTypes.addMimeType("application/zip", "zip");
        MimeTypes.addMimeType("application/vnd.3M.Post-it-Notes", new String[0]);
        MimeTypes.addMimeType("application/vnd.accpac.simply.aso", new String[0]);
        MimeTypes.addMimeType("application/vnd.accpac.simply.imp", new String[0]);
        MimeTypes.addMimeType("application/vnd.acucobol", new String[0]);
        MimeTypes.addMimeType("application/vnd.aether.imp", new String[0]);
        MimeTypes.addMimeType("application/vnd.anser-web-certificate-issue-initiation", new String[0]);
        MimeTypes.addMimeType("application/vnd.anser-web-funds-transfer-initiation", new String[0]);
        MimeTypes.addMimeType("application/vnd.audiograph", new String[0]);
        MimeTypes.addMimeType("application/vnd.bmi", new String[0]);
        MimeTypes.addMimeType("application/vnd.businessobjects", new String[0]);
        MimeTypes.addMimeType("application/vnd.canon-cpdl", new String[0]);
        MimeTypes.addMimeType("application/vnd.canon-lips", new String[0]);
        MimeTypes.addMimeType("application/vnd.cinderella", "cdy");
        MimeTypes.addMimeType("application/vnd.claymore", new String[0]);
        MimeTypes.addMimeType("application/vnd.commerce-battelle", new String[0]);
        MimeTypes.addMimeType("application/vnd.commonspace", new String[0]);
        MimeTypes.addMimeType("application/vnd.comsocaller", new String[0]);
        MimeTypes.addMimeType("application/vnd.contact.cmsg", new String[0]);
        MimeTypes.addMimeType("application/vnd.cosmocaller", new String[0]);
        MimeTypes.addMimeType("application/vnd.ctc-posml", new String[0]);
        MimeTypes.addMimeType("application/vnd.cups-postscript", new String[0]);
        MimeTypes.addMimeType("application/vnd.cups-raster", new String[0]);
        MimeTypes.addMimeType("application/vnd.cups-raw", new String[0]);
        MimeTypes.addMimeType("application/vnd.cybank", new String[0]);
        MimeTypes.addMimeType("application/vnd.dna", new String[0]);
        MimeTypes.addMimeType("application/vnd.dpgraph", new String[0]);
        MimeTypes.addMimeType("application/vnd.dxr", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecdis-update", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.chart", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.filerequest", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.fileupdate", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.series", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.seriesrequest", new String[0]);
        MimeTypes.addMimeType("application/vnd.ecowin.seriesupdate", new String[0]);
        MimeTypes.addMimeType("application/vnd.enliven", new String[0]);
        MimeTypes.addMimeType("application/vnd.epson.esf", new String[0]);
        MimeTypes.addMimeType("application/vnd.epson.msf", new String[0]);
        MimeTypes.addMimeType("application/vnd.epson.quickanime", new String[0]);
        MimeTypes.addMimeType("application/vnd.epson.salt", new String[0]);
        MimeTypes.addMimeType("application/vnd.epson.ssf", new String[0]);
        MimeTypes.addMimeType("application/vnd.ericsson.quickcall", new String[0]);
        MimeTypes.addMimeType("application/vnd.eudora.data", new String[0]);
        MimeTypes.addMimeType("application/vnd.fdf", new String[0]);
        MimeTypes.addMimeType("application/vnd.ffsns", new String[0]);
        MimeTypes.addMimeType("application/vnd.flographit", new String[0]);
        MimeTypes.addMimeType("application/vnd.framemaker", new String[0]);
        MimeTypes.addMimeType("application/vnd.fsc.weblaunch", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujitsu.oasys", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujitsu.oasys2", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujitsu.oasys3", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujitsu.oasysgp", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujitsu.oasysprs", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujixerox.ddd", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujixerox.docuworks", new String[0]);
        MimeTypes.addMimeType("application/vnd.fujixerox.docuworks.binder", new String[0]);
        MimeTypes.addMimeType("application/vnd.fut-misnet", new String[0]);
        MimeTypes.addMimeType("application/vnd.grafeq", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-account", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-identity-message", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-injector", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-tool-message", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-tool-template", new String[0]);
        MimeTypes.addMimeType("application/vnd.groove-vcard", new String[0]);
        MimeTypes.addMimeType("application/vnd.hhe.lesson-player", new String[0]);
        MimeTypes.addMimeType("application/vnd.hp-HPGL", new String[0]);
        MimeTypes.addMimeType("application/vnd.hp-PCL", new String[0]);
        MimeTypes.addMimeType("application/vnd.hp-PCLXL", new String[0]);
        MimeTypes.addMimeType("application/vnd.hp-hpid", new String[0]);
        MimeTypes.addMimeType("application/vnd.hp-hps", new String[0]);
        MimeTypes.addMimeType("application/vnd.httphone", new String[0]);
        MimeTypes.addMimeType("application/vnd.hzn-3d-crossword", new String[0]);
        MimeTypes.addMimeType("application/vnd.ibm.MiniPay", new String[0]);
        MimeTypes.addMimeType("application/vnd.ibm.afplinedata", new String[0]);
        MimeTypes.addMimeType("application/vnd.ibm.modcap", new String[0]);
        MimeTypes.addMimeType("application/vnd.informix-visionary", new String[0]);
        MimeTypes.addMimeType("application/vnd.intercon.formnet", new String[0]);
        MimeTypes.addMimeType("application/vnd.intertrust.digibox", new String[0]);
        MimeTypes.addMimeType("application/vnd.intertrust.nncp", new String[0]);
        MimeTypes.addMimeType("application/vnd.intu.qbo", new String[0]);
        MimeTypes.addMimeType("application/vnd.intu.qfx", new String[0]);
        MimeTypes.addMimeType("application/vnd.irepository.package+xml", new String[0]);
        MimeTypes.addMimeType("application/vnd.is-xpr", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-directory-service", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-jpnstore-wakeup", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-payment-wakeup", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-registration", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-registration-wakeup", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-setstore-wakeup", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-verification", new String[0]);
        MimeTypes.addMimeType("application/vnd.japannet-verification-wakeup", new String[0]);
        MimeTypes.addMimeType("application/vnd.koan", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-1-2-3", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-approach", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-freelance", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-notes", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-organizer", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-screencam", new String[0]);
        MimeTypes.addMimeType("application/vnd.lotus-wordpro", new String[0]);
        MimeTypes.addMimeType("application/vnd.mcd", new String[0]);
        MimeTypes.addMimeType("application/vnd.mediastation.cdkey", new String[0]);
        MimeTypes.addMimeType("application/vnd.meridian-slingshot", new String[0]);
        MimeTypes.addMimeType("application/vnd.mif", new String[0]);
        MimeTypes.addMimeType("application/vnd.minisoft-hp3000-save", new String[0]);
        MimeTypes.addMimeType("application/vnd.mitsubishi.misty-guard.trustweb", new String[0]);
        MimeTypes.addMimeType("application/vnd.mobius.daf", new String[0]);
        MimeTypes.addMimeType("application/vnd.mobius.dis", new String[0]);
        MimeTypes.addMimeType("application/vnd.mobius.msl", new String[0]);
        MimeTypes.addMimeType("application/vnd.mobius.plc", new String[0]);
        MimeTypes.addMimeType("application/vnd.mobius.txf", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.adsi", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.fis", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.gotap", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.kmr", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.ttc", new String[0]);
        MimeTypes.addMimeType("application/vnd.motorola.flexsuite.wem", new String[0]);
        MimeTypes.addMimeType("application/vnd.mozilla.xul+xml", "xul");
        MimeTypes.addMimeType("application/vnd.ms-artgalry", new String[0]);
        MimeTypes.addMimeType("application/vnd.ms-asf", new String[0]);
        MimeTypes.addMimeType("application/vnd.ms-excel", "xls", "xlb", "xlt");
        MimeTypes.addMimeType("application/vnd.ms-lrm", new String[0]);
        MimeTypes.addMimeType("application/vnd.ms-pki.seccat", "cat");
        MimeTypes.addMimeType("application/vnd.ms-pki.stl", "stl");
        MimeTypes.addMimeType("application/vnd.ms-powerpoint", "ppt", "pps");
        MimeTypes.addMimeType("application/vnd.ms-project", new String[0]);
        MimeTypes.addMimeType("application/vnd.ms-tnef", new String[0]);
        MimeTypes.addMimeType("application/vnd.ms-works", new String[0]);
        MimeTypes.addMimeType("application/vnd.mseq", new String[0]);
        MimeTypes.addMimeType("application/vnd.msign", new String[0]);
        MimeTypes.addMimeType("application/vnd.music-niff", new String[0]);
        MimeTypes.addMimeType("application/vnd.musician", new String[0]);
        MimeTypes.addMimeType("application/vnd.netfpx", new String[0]);
        MimeTypes.addMimeType("application/vnd.noblenet-directory", new String[0]);
        MimeTypes.addMimeType("application/vnd.noblenet-sealer", new String[0]);
        MimeTypes.addMimeType("application/vnd.noblenet-web", new String[0]);
        MimeTypes.addMimeType("application/vnd.novadigm.EDM", new String[0]);
        MimeTypes.addMimeType("application/vnd.novadigm.EDX", new String[0]);
        MimeTypes.addMimeType("application/vnd.novadigm.EXT", new String[0]);
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.chart", "odc");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.database", "odb");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.formula", "odf");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.graphics", "odg");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.graphics-template", "otg");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.image", "odi");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.presentation", "odp");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.presentation-template", "otp");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.spreadsheet", "ods");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.spreadsheet-template", "ots");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.text", "odt");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.text-master", "odm");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.text-template", "ott");
        MimeTypes.addMimeType("application/vnd.oasis.opendocument.text-web", "oth");
        MimeTypes.addMimeType("application/vnd.osa.netdeploy", new String[0]);
        MimeTypes.addMimeType("application/vnd.palm", new String[0]);
        MimeTypes.addMimeType("application/vnd.pg.format", new String[0]);
        MimeTypes.addMimeType("application/vnd.pg.osasli", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder6", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder6-s", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder7", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder7-s", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder75", new String[0]);
        MimeTypes.addMimeType("application/vnd.powerbuilder75-s", new String[0]);
        MimeTypes.addMimeType("application/vnd.previewsystems.box", new String[0]);
        MimeTypes.addMimeType("application/vnd.publishare-delta-tree", new String[0]);
        MimeTypes.addMimeType("application/vnd.pvi.ptid1", new String[0]);
        MimeTypes.addMimeType("application/vnd.pwg-xhtml-print+xml", new String[0]);
        MimeTypes.addMimeType("application/vnd.rapid", new String[0]);
        MimeTypes.addMimeType("application/vnd.rim.cod", "cod");
        MimeTypes.addMimeType("application/vnd.s3sms", new String[0]);
        MimeTypes.addMimeType("application/vnd.seemail", new String[0]);
        MimeTypes.addMimeType("application/vnd.shana.informed.formdata", new String[0]);
        MimeTypes.addMimeType("application/vnd.shana.informed.formtemplate", new String[0]);
        MimeTypes.addMimeType("application/vnd.shana.informed.interchange", new String[0]);
        MimeTypes.addMimeType("application/vnd.shana.informed.package", new String[0]);
        MimeTypes.addMimeType("application/vnd.smaf", "mmf");
        MimeTypes.addMimeType("application/vnd.sss-cod", new String[0]);
        MimeTypes.addMimeType("application/vnd.sss-dtf", new String[0]);
        MimeTypes.addMimeType("application/vnd.sss-ntf", new String[0]);
        MimeTypes.addMimeType("application/vnd.stardivision.calc", "sdc");
        MimeTypes.addMimeType("application/vnd.stardivision.draw", "sda");
        MimeTypes.addMimeType("application/vnd.stardivision.impress", "sdd", "sdp");
        MimeTypes.addMimeType("application/vnd.stardivision.math", "smf");
        MimeTypes.addMimeType("application/vnd.stardivision.writer", "sdw", "vor");
        MimeTypes.addMimeType("application/vnd.stardivision.writer-global", "sgl");
        MimeTypes.addMimeType("application/vnd.street-stream", new String[0]);
        MimeTypes.addMimeType("application/vnd.sun.xml.calc", "sxc");
        MimeTypes.addMimeType("application/vnd.sun.xml.calc.template", "stc");
        MimeTypes.addMimeType("application/vnd.sun.xml.draw", "sxd");
        MimeTypes.addMimeType("application/vnd.sun.xml.draw.template", "std");
        MimeTypes.addMimeType("application/vnd.sun.xml.impress", "sxi");
        MimeTypes.addMimeType("application/vnd.sun.xml.impress.template", "sti");
        MimeTypes.addMimeType("application/vnd.sun.xml.math", "sxm");
        MimeTypes.addMimeType("application/vnd.sun.xml.writer", "sxw");
        MimeTypes.addMimeType("application/vnd.sun.xml.writer.global", "sxg");
        MimeTypes.addMimeType("application/vnd.sun.xml.writer.template", "stw");
        MimeTypes.addMimeType("application/vnd.svd", new String[0]);
        MimeTypes.addMimeType("application/vnd.swiftview-ics", new String[0]);
        MimeTypes.addMimeType("application/vnd.symbian.install", "sis");
        MimeTypes.addMimeType("application/vnd.triscape.mxs", new String[0]);
        MimeTypes.addMimeType("application/vnd.trueapp", new String[0]);
        MimeTypes.addMimeType("application/vnd.truedoc", new String[0]);
        MimeTypes.addMimeType("application/vnd.tve-trigger", new String[0]);
        MimeTypes.addMimeType("application/vnd.ufdl", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.alert", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.alert-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.bearer-choice", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.bearer-choice-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.cacheop", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.cacheop-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.channel", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.channel-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.list", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.list-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.listcmd", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.listcmd-wbxml", new String[0]);
        MimeTypes.addMimeType("application/vnd.uplanet.signal", new String[0]);
        MimeTypes.addMimeType("application/vnd.vcx", new String[0]);
        MimeTypes.addMimeType("application/vnd.vectorworks", new String[0]);
        MimeTypes.addMimeType("application/vnd.vidsoft.vidconference", new String[0]);
        MimeTypes.addMimeType("application/vnd.visio", "vsd");
        MimeTypes.addMimeType("application/vnd.vividence.scriptfile", new String[0]);
        MimeTypes.addMimeType("application/vnd.wap.sic", new String[0]);
        MimeTypes.addMimeType("application/vnd.wap.slc", new String[0]);
        MimeTypes.addMimeType("application/vnd.wap.wbxml", "wbxml");
        MimeTypes.addMimeType("application/vnd.wap.wmlc", "wmlc");
        MimeTypes.addMimeType("application/vnd.wap.wmlscriptc", "wmlsc");
        MimeTypes.addMimeType("application/vnd.webturbo", new String[0]);
        MimeTypes.addMimeType("application/vnd.wrq-hp3000-labelled", new String[0]);
        MimeTypes.addMimeType("application/vnd.wt.stf", new String[0]);
        MimeTypes.addMimeType("application/vnd.xara", new String[0]);
        MimeTypes.addMimeType("application/vnd.xfdl", new String[0]);
        MimeTypes.addMimeType("application/vnd.yellowriver-custom-menu", new String[0]);
        MimeTypes.addMimeType("application/x-123", "wk");
        MimeTypes.addMimeType("application/x-abiword", "abw");
        MimeTypes.addMimeType("application/x-apple-diskimage", "dmg");
        MimeTypes.addMimeType("application/x-bcpio", "bcpio");
        MimeTypes.addMimeType("application/x-bittorrent", "torrent");
        MimeTypes.addMimeType("application/x-cdf", "cdf");
        MimeTypes.addMimeType("application/x-cdlink", "vcd");
        MimeTypes.addMimeType("application/x-chess-pgn", "pgn");
        MimeTypes.addMimeType("application/x-core", new String[0]);
        MimeTypes.addMimeType("application/x-cpio", "cpio");
        MimeTypes.addMimeType("application/x-csh", "csh");
        MimeTypes.addMimeType("application/x-debian-package", "deb", "udeb");
        MimeTypes.addMimeType("application/x-director", "dcr", "dir", "dxr");
        MimeTypes.addMimeType("application/x-dms", "dms");
        MimeTypes.addMimeType("application/x-doom", "wad");
        MimeTypes.addMimeType("application/x-dvi", "dvi");
        MimeTypes.addMimeType("application/x-executable", new String[0]);
        MimeTypes.addMimeType("application/x-flac", "flac");
        MimeTypes.addMimeType("application/x-font", "pfa", "pfb", "gsf", "pcf", "pcf.Z");
        MimeTypes.addMimeType("application/x-freemind", "mm");
        MimeTypes.addMimeType("application/x-futuresplash", "spl");
        MimeTypes.addMimeType("application/x-gnumeric", "gnumeric");
        MimeTypes.addMimeType("application/x-go-sgf", "sgf");
        MimeTypes.addMimeType("application/x-graphing-calculator", "gcf");
        MimeTypes.addMimeType("application/x-gtar", "gtar", "tgz", "taz", "tar.bz2");
        MimeTypes.addMimeType("application/x-hdf", "hdf");
        MimeTypes.addMimeType("application/x-ica", "ica");
        MimeTypes.addMimeType("application/x-internet-signup", "ins", "isp");
        MimeTypes.addMimeType("application/x-iphone", "iii");
        MimeTypes.addMimeType("application/x-iso9660-image", "iso");
        MimeTypes.addMimeType("application/x-java-applet", new String[0]);
        MimeTypes.addMimeType("application/x-java-bean", new String[0]);
        MimeTypes.addMimeType("application/x-java-jnlp-file", "jnlp");
        MimeTypes.addMimeType("application/x-javascript", "js");
        MimeTypes.addMimeType("application/x-jmol", "jmz");
        MimeTypes.addMimeType("application/x-kchart", "chrt");
        MimeTypes.addMimeType("application/x-kdelnk", new String[0]);
        MimeTypes.addMimeType("application/x-killustrator", "kil");
        MimeTypes.addMimeType("application/x-koan", "skp", "skd", "skt", "skm");
        MimeTypes.addMimeType("application/x-kpresenter", "kpr", "kpt");
        MimeTypes.addMimeType("application/x-kspread", "ksp");
        MimeTypes.addMimeType("application/x-kword", "kwd", "kwt");
        MimeTypes.addMimeType("application/x-latex", "latex");
        MimeTypes.addMimeType("application/x-lha", "lha");
        MimeTypes.addMimeType("application/x-lzh", "lzh");
        MimeTypes.addMimeType("application/x-lzx", "lzx");
        MimeTypes.addMimeType("application/x-maker", "frm", "maker", "frame", "fm", "fb", "book", "fbdoc");
        MimeTypes.addMimeType("application/x-mif", "mif");
        MimeTypes.addMimeType("application/x-ms-wmd", "wmd");
        MimeTypes.addMimeType("application/x-ms-wmz", "wmz");
        MimeTypes.addMimeType("application/x-msdos-program", "com", "exe", "bat", "dll");
        MimeTypes.addMimeType("application/x-msi", "msi");
        MimeTypes.addMimeType("application/x-netcdf", "nc");
        MimeTypes.addMimeType("application/x-ns-proxy-autoconfig", "pac");
        MimeTypes.addMimeType("application/x-nwc", "nwc");
        MimeTypes.addMimeType("application/x-object", "o");
        MimeTypes.addMimeType("application/x-oz-application", "oza");
        MimeTypes.addMimeType("application/x-pkcs7-certreqresp", "p7r");
        MimeTypes.addMimeType("application/x-pkcs7-crl", "crl");
        MimeTypes.addMimeType("application/x-python-code", "pyc", "pyo");
        MimeTypes.addMimeType("application/x-quicktimeplayer", "qtl");
        MimeTypes.addMimeType("application/x-redhat-package-manager", "rpm");
        MimeTypes.addMimeType("application/x-rx", new String[0]);
        MimeTypes.addMimeType("application/x-sh", "sh");
        MimeTypes.addMimeType("application/x-shar", "shar");
        MimeTypes.addMimeType("application/x-shellscript", new String[0]);
        MimeTypes.addMimeType("application/x-shockwave-flash", "swf", "swfl");
        MimeTypes.addMimeType("application/x-stuffit", "sit");
        MimeTypes.addMimeType("application/x-sv4cpio", "sv4cpio");
        MimeTypes.addMimeType("application/x-sv4crc", "sv4crc");
        MimeTypes.addMimeType("application/x-tar", "tar");
        MimeTypes.addMimeType("application/x-tcl", "tcl");
        MimeTypes.addMimeType("application/x-tex-gf", "gf");
        MimeTypes.addMimeType("application/x-tex-pk", "pk");
        MimeTypes.addMimeType("application/x-texinfo", "texinfo", "texi");
        MimeTypes.addMimeType("application/x-trash", "~", "%", "bak", "old", "sik");
        MimeTypes.addMimeType("application/x-troff", "t", "tr", "roff");
        MimeTypes.addMimeType("application/x-troff-man", "man");
        MimeTypes.addMimeType("application/x-troff-me", "me");
        MimeTypes.addMimeType("application/x-troff-ms", "ms");
        MimeTypes.addMimeType("application/x-ustar", "ustar");
        MimeTypes.addMimeType("application/x-videolan", new String[0]);
        MimeTypes.addMimeType("application/x-wais-source", "src");
        MimeTypes.addMimeType("application/x-wingz", "wz");
        MimeTypes.addMimeType("application/x-x509-ca-cert", "crt");
        MimeTypes.addMimeType("application/x-xcf", "xcf");
        MimeTypes.addMimeType("application/x-xfig", "fig");
        MimeTypes.addMimeType("application/x-xpinstall", "xpi");
        MimeTypes.addMimeType("audio/32kadpcm", new String[0]);
        MimeTypes.addMimeType("audio/basic", "au", "snd");
        MimeTypes.addMimeType("audio/dvi4", new String[0]);
        MimeTypes.addMimeType("audio/g.722.1", new String[0]);
        MimeTypes.addMimeType("audio/g722", new String[0]);
        MimeTypes.addMimeType("audio/g723", new String[0]);
        MimeTypes.addMimeType("audio/g726-16", new String[0]);
        MimeTypes.addMimeType("audio/g726-24", new String[0]);
        MimeTypes.addMimeType("audio/g726-32", new String[0]);
        MimeTypes.addMimeType("audio/g726-40", new String[0]);
        MimeTypes.addMimeType("audio/g728", new String[0]);
        MimeTypes.addMimeType("audio/g729", new String[0]);
        MimeTypes.addMimeType("audio/g729d", new String[0]);
        MimeTypes.addMimeType("audio/g729e", new String[0]);
        MimeTypes.addMimeType("audio/gsm", new String[0]);
        MimeTypes.addMimeType("audio/gsm-efr", new String[0]);
        MimeTypes.addMimeType("audio/l8", new String[0]);
        MimeTypes.addMimeType("audio/l16", new String[0]);
        MimeTypes.addMimeType("audio/lpc", new String[0]);
        MimeTypes.addMimeType("audio/midi", "mid", "midi", "kar");
        MimeTypes.addMimeType("audio/mp4a-latm", new String[0]);
        MimeTypes.addMimeType("audio/mpa", new String[0]);
        MimeTypes.addMimeType("audio/mpa-robust", new String[0]);
        MimeTypes.addMimeType("audio/mpeg", "mpga", "mpega", "mp2", "mp3", "m4a");
        MimeTypes.addMimeType("audio/mpegurl", "m3u");
        MimeTypes.addMimeType("audio/parityfec", new String[0]);
        MimeTypes.addMimeType("audio/pcma", new String[0]);
        MimeTypes.addMimeType("audio/pcmu", new String[0]);
        MimeTypes.addMimeType("audio/prs.sid", "sid");
        MimeTypes.addMimeType("audio/qcelp", new String[0]);
        MimeTypes.addMimeType("audio/red", new String[0]);
        MimeTypes.addMimeType("audio/telephone-event", new String[0]);
        MimeTypes.addMimeType("audio/tone", new String[0]);
        MimeTypes.addMimeType("audio/vdvi", new String[0]);
        MimeTypes.addMimeType("audio/vnd.cisco.nse", new String[0]);
        MimeTypes.addMimeType("audio/vnd.cns.anp1", new String[0]);
        MimeTypes.addMimeType("audio/vnd.cns.inf1", new String[0]);
        MimeTypes.addMimeType("audio/vnd.digital-winds", new String[0]);
        MimeTypes.addMimeType("audio/vnd.everad.plj", new String[0]);
        MimeTypes.addMimeType("audio/vnd.lucent.voice", new String[0]);
        MimeTypes.addMimeType("audio/vnd.nortel.vbk", new String[0]);
        MimeTypes.addMimeType("audio/vnd.nuera.ecelp4800", new String[0]);
        MimeTypes.addMimeType("audio/vnd.nuera.ecelp7470", new String[0]);
        MimeTypes.addMimeType("audio/vnd.nuera.ecelp9600", new String[0]);
        MimeTypes.addMimeType("audio/vnd.octel.sbc", new String[0]);
        MimeTypes.addMimeType("audio/vnd.qcelp", new String[0]);
        MimeTypes.addMimeType("audio/vnd.rhetorex.32kadpcm", new String[0]);
        MimeTypes.addMimeType("audio/vnd.vmx.cvsd", new String[0]);
        MimeTypes.addMimeType("audio/x-aiff", "aif", "aiff", "aifc");
        MimeTypes.addMimeType("audio/x-gsm", "gsm");
        MimeTypes.addMimeType("audio/x-mpegurl", "m3u");
        MimeTypes.addMimeType("audio/x-ms-wma", "wma");
        MimeTypes.addMimeType("audio/x-ms-wax", "wax");
        MimeTypes.addMimeType("audio/x-pn-realaudio-plugin", new String[0]);
        MimeTypes.addMimeType("audio/x-pn-realaudio", "ra", "rm", "ram");
        MimeTypes.addMimeType("audio/x-realaudio", "ra");
        MimeTypes.addMimeType("audio/x-scpls", "pls");
        MimeTypes.addMimeType("audio/x-sd2", "sd2");
        MimeTypes.addMimeType("audio/x-wav", "wav");
        MimeTypes.addMimeType("chemical/x-alchemy", "alc");
        MimeTypes.addMimeType("chemical/x-cache", "cac", "cache");
        MimeTypes.addMimeType("chemical/x-cache-csf", "csf");
        MimeTypes.addMimeType("chemical/x-cactvs-binary", "cbin", "cascii", "ctab");
        MimeTypes.addMimeType("chemical/x-cdx", "cdx");
        MimeTypes.addMimeType("chemical/x-cerius", "cer");
        MimeTypes.addMimeType("chemical/x-chem3d", "c3d");
        MimeTypes.addMimeType("chemical/x-chemdraw", "chm");
        MimeTypes.addMimeType("chemical/x-cif", "cif");
        MimeTypes.addMimeType("chemical/x-cmdf", "cmdf");
        MimeTypes.addMimeType("chemical/x-cml", "cml");
        MimeTypes.addMimeType("chemical/x-compass", "cpa");
        MimeTypes.addMimeType("chemical/x-crossfire", "bsd");
        MimeTypes.addMimeType("chemical/x-csml", "csml", "csm");
        MimeTypes.addMimeType("chemical/x-ctx", "ctx");
        MimeTypes.addMimeType("chemical/x-cxf", "cxf", "cef");
        MimeTypes.addMimeType("chemical/x-embl-dl-nucleotide", "emb", "embl");
        MimeTypes.addMimeType("chemical/x-galactic-spc", "spc");
        MimeTypes.addMimeType("chemical/x-gamess-input", "inp", "gam", "gamin");
        MimeTypes.addMimeType("chemical/x-gaussian-checkpoint", "fch", "fchk");
        MimeTypes.addMimeType("chemical/x-gaussian-cube", "cub");
        MimeTypes.addMimeType("chemical/x-gaussian-input", "gau", "gjc", "gjf");
        MimeTypes.addMimeType("chemical/x-gaussian-log", "gal");
        MimeTypes.addMimeType("chemical/x-gcg8-sequence", "gcg");
        MimeTypes.addMimeType("chemical/x-genbank", "gen");
        MimeTypes.addMimeType("chemical/x-hin", "hin");
        MimeTypes.addMimeType("chemical/x-isostar", "istr", "ist");
        MimeTypes.addMimeType("chemical/x-jcamp-dx", "jdx", "dx");
        MimeTypes.addMimeType("chemical/x-kinemage", "kin");
        MimeTypes.addMimeType("chemical/x-macmolecule", "mcm");
        MimeTypes.addMimeType("chemical/x-macromodel-input", "mmd", "mmod");
        MimeTypes.addMimeType("chemical/x-mdl-molfile", "mol");
        MimeTypes.addMimeType("chemical/x-mdl-rdfile", "rd");
        MimeTypes.addMimeType("chemical/x-mdl-rxnfile", "rxn");
        MimeTypes.addMimeType("chemical/x-mdl-sdfile", "sd", "sdf");
        MimeTypes.addMimeType("chemical/x-mdl-tgf", "tgf");
        MimeTypes.addMimeType("chemical/x-mmcif", "mcif");
        MimeTypes.addMimeType("chemical/x-mol2", "mol2");
        MimeTypes.addMimeType("chemical/x-molconn-Z", "b");
        MimeTypes.addMimeType("chemical/x-mopac-graph", "gpt");
        MimeTypes.addMimeType("chemical/x-mopac-input", "mop", "mopcrt", "mpc", "dat", "zmt");
        MimeTypes.addMimeType("chemical/x-mopac-out", "moo");
        MimeTypes.addMimeType("chemical/x-mopac-vib", "mvb");
        MimeTypes.addMimeType("chemical/x-ncbi-asn1", "asn");
        MimeTypes.addMimeType("chemical/x-ncbi-asn1-ascii", "prt", "ent");
        MimeTypes.addMimeType("chemical/x-ncbi-asn1-binary", "val", "aso");
        MimeTypes.addMimeType("chemical/x-ncbi-asn1-spec", "asn");
        MimeTypes.addMimeType("chemical/x-pdb", "pdb", "ent");
        MimeTypes.addMimeType("chemical/x-rosdal", "ros");
        MimeTypes.addMimeType("chemical/x-swissprot", "sw");
        MimeTypes.addMimeType("chemical/x-vamas-iso14976", "vms");
        MimeTypes.addMimeType("chemical/x-vmd", "vmd");
        MimeTypes.addMimeType("chemical/x-xtel", "xtel");
        MimeTypes.addMimeType("chemical/x-xyz", "xyz");
        MimeTypes.addMimeType("image/cgm", new String[0]);
        MimeTypes.addMimeType("image/g3fax", new String[0]);
        MimeTypes.addMimeType("image/gif", "gif");
        MimeTypes.addMimeType("image/ief", "ief");
        MimeTypes.addMimeType("image/jpeg", "jpeg", "jpg", "jpe");
        MimeTypes.addMimeType("image/naplps", new String[0]);
        MimeTypes.addMimeType("image/pcx", "pcx");
        MimeTypes.addMimeType("image/png", "png");
        MimeTypes.addMimeType("image/prs.btif", new String[0]);
        MimeTypes.addMimeType("image/prs.pti", new String[0]);
        MimeTypes.addMimeType("image/svg+xml", "svg", "svgz");
        MimeTypes.addMimeType("image/tiff", "tiff", "tif");
        MimeTypes.addMimeType("image/vnd.cns.inf2", new String[0]);
        MimeTypes.addMimeType("image/vnd.djvu", "djvu", "djv");
        MimeTypes.addMimeType("image/vnd.dwg", new String[0]);
        MimeTypes.addMimeType("image/vnd.dxf", new String[0]);
        MimeTypes.addMimeType("image/vnd.fastbidsheet", new String[0]);
        MimeTypes.addMimeType("image/vnd.fpx", new String[0]);
        MimeTypes.addMimeType("image/vnd.fst", new String[0]);
        MimeTypes.addMimeType("image/vnd.fujixerox.edmics-mmr", new String[0]);
        MimeTypes.addMimeType("image/vnd.fujixerox.edmics-rlc", new String[0]);
        MimeTypes.addMimeType("image/vnd.mix", new String[0]);
        MimeTypes.addMimeType("image/vnd.net-fpx", new String[0]);
        MimeTypes.addMimeType("image/vnd.svf", new String[0]);
        MimeTypes.addMimeType("image/vnd.wap.wbmp", "wbmp");
        MimeTypes.addMimeType("image/vnd.xiff", new String[0]);
        MimeTypes.addMimeType("image/x-cmu-raster", "ras");
        MimeTypes.addMimeType("image/x-coreldraw", "cdr");
        MimeTypes.addMimeType("image/x-coreldrawpattern", "pat");
        MimeTypes.addMimeType("image/x-coreldrawtemplate", "cdt");
        MimeTypes.addMimeType("image/x-corelphotopaint", "cpt");
        MimeTypes.addMimeType("image/x-icon", "ico");
        MimeTypes.addMimeType("image/x-jg", "art");
        MimeTypes.addMimeType("image/x-jng", "jng");
        MimeTypes.addMimeType("image/x-ms-bmp", "bmp");
        MimeTypes.addMimeType("image/x-photoshop", "psd");
        MimeTypes.addMimeType("image/x-portable-anymap", "pnm");
        MimeTypes.addMimeType("image/x-portable-bitmap", "pbm");
        MimeTypes.addMimeType("image/x-portable-graymap", "pgm");
        MimeTypes.addMimeType("image/x-portable-pixmap", "ppm");
        MimeTypes.addMimeType("image/x-rgb", "rgb");
        MimeTypes.addMimeType("image/x-xbitmap", "xbm");
        MimeTypes.addMimeType("image/x-xpixmap", "xpm");
        MimeTypes.addMimeType("image/x-xwindowdump", "xwd");
        MimeTypes.addMimeType("inode/chardevice", new String[0]);
        MimeTypes.addMimeType("inode/blockdevice", new String[0]);
        MimeTypes.addMimeType("inode/directory-locked", new String[0]);
        MimeTypes.addMimeType("inode/directory", new String[0]);
        MimeTypes.addMimeType("inode/fifo", new String[0]);
        MimeTypes.addMimeType("inode/socket", new String[0]);
        MimeTypes.addMimeType("message/delivery-status", new String[0]);
        MimeTypes.addMimeType("message/disposition-notification", new String[0]);
        MimeTypes.addMimeType("message/external-body", new String[0]);
        MimeTypes.addMimeType("message/http", new String[0]);
        MimeTypes.addMimeType("message/s-http", new String[0]);
        MimeTypes.addMimeType("message/news", new String[0]);
        MimeTypes.addMimeType("message/partial", new String[0]);
        MimeTypes.addMimeType("message/rfc822", new String[0]);
        MimeTypes.addMimeType("model/iges", "igs", "iges");
        MimeTypes.addMimeType("model/mesh", "msh", "mesh", "silo");
        MimeTypes.addMimeType("model/vnd.dwf", new String[0]);
        MimeTypes.addMimeType("model/vnd.flatland.3dml", new String[0]);
        MimeTypes.addMimeType("model/vnd.gdl", new String[0]);
        MimeTypes.addMimeType("model/vnd.gs-gdl", new String[0]);
        MimeTypes.addMimeType("model/vnd.gtw", new String[0]);
        MimeTypes.addMimeType("model/vnd.mts", new String[0]);
        MimeTypes.addMimeType("model/vnd.vtu", new String[0]);
        MimeTypes.addMimeType("model/vrml", "wrl", "vrml");
        MimeTypes.addMimeType("multipart/alternative", new String[0]);
        MimeTypes.addMimeType("multipart/appledouble", new String[0]);
        MimeTypes.addMimeType("multipart/byteranges", new String[0]);
        MimeTypes.addMimeType("multipart/digest", new String[0]);
        MimeTypes.addMimeType("multipart/encrypted", new String[0]);
        MimeTypes.addMimeType("multipart/form-data", new String[0]);
        MimeTypes.addMimeType("multipart/header-set", new String[0]);
        MimeTypes.addMimeType("multipart/mixed", new String[0]);
        MimeTypes.addMimeType("multipart/parallel", new String[0]);
        MimeTypes.addMimeType("multipart/related", new String[0]);
        MimeTypes.addMimeType("multipart/report", new String[0]);
        MimeTypes.addMimeType("multipart/signed", new String[0]);
        MimeTypes.addMimeType("multipart/voice-message", new String[0]);
        MimeTypes.addMimeType("text/calendar", "ics", "icz");
        MimeTypes.addMimeType("text/comma-separated-values", "csv");
        MimeTypes.addMimeType("text/css", "css");
        MimeTypes.addMimeType("text/directory", new String[0]);
        MimeTypes.addMimeType("text/english", new String[0]);
        MimeTypes.addMimeType("text/enriched", new String[0]);
        MimeTypes.addMimeType("text/h323", "323");
        MimeTypes.addMimeType("text/html", "html", "htm", "shtml");
        MimeTypes.addMimeType("text/iuls", "uls");
        MimeTypes.addMimeType("text/mathml", "mml");
        MimeTypes.addMimeType("text/parityfec", new String[0]);
        MimeTypes.addMimeType("text/plain", "asc", "txt", "text", "diff", "pot");
        MimeTypes.addMimeType("text/prs.lines.tag", new String[0]);
        MimeTypes.addMimeType("text/x-psp", "psp");
        MimeTypes.addMimeType("text/rfc822-headers", new String[0]);
        MimeTypes.addMimeType("text/richtext", "rtx");
        MimeTypes.addMimeType("text/rtf", "rtf");
        MimeTypes.addMimeType("text/scriptlet", "sct", "wsc");
        MimeTypes.addMimeType("text/t140", new String[0]);
        MimeTypes.addMimeType("text/texmacs", "tm", "ts");
        MimeTypes.addMimeType("text/tab-separated-values", "tsv");
        MimeTypes.addMimeType("text/uri-list", new String[0]);
        MimeTypes.addMimeType("text/vnd.abc", new String[0]);
        MimeTypes.addMimeType("text/vnd.curl", new String[0]);
        MimeTypes.addMimeType("text/vnd.DMClientScript", new String[0]);
        MimeTypes.addMimeType("text/vnd.flatland.3dml", new String[0]);
        MimeTypes.addMimeType("text/vnd.fly", new String[0]);
        MimeTypes.addMimeType("text/vnd.fmi.flexstor", new String[0]);
        MimeTypes.addMimeType("text/vnd.in3d.3dml", new String[0]);
        MimeTypes.addMimeType("text/vnd.in3d.spot", new String[0]);
        MimeTypes.addMimeType("text/vnd.IPTC.NewsML", new String[0]);
        MimeTypes.addMimeType("text/vnd.IPTC.NITF", new String[0]);
        MimeTypes.addMimeType("text/vnd.latex-z", new String[0]);
        MimeTypes.addMimeType("text/vnd.motorola.reflex", new String[0]);
        MimeTypes.addMimeType("text/vnd.ms-mediapackage", new String[0]);
        MimeTypes.addMimeType("text/vnd.sun.j2me.app-descriptor", "jad");
        MimeTypes.addMimeType("text/vnd.wap.si", new String[0]);
        MimeTypes.addMimeType("text/vnd.wap.sl", new String[0]);
        MimeTypes.addMimeType("text/vnd.wap.wml", "wml");
        MimeTypes.addMimeType("text/vnd.wap.wmlscript", "wmls");
        MimeTypes.addMimeType("text/x-bibtex", "bib");
        MimeTypes.addMimeType("text/x-c++hdr", "h++", "hpp", "hxx", "hh");
        MimeTypes.addMimeType("text/x-c++src", "c++", "cpp", "cxx", "cc");
        MimeTypes.addMimeType("text/x-chdr", "h");
        MimeTypes.addMimeType("text/x-crontab", new String[0]);
        MimeTypes.addMimeType("text/x-csh", "csh");
        MimeTypes.addMimeType("text/x-csrc", "c");
        MimeTypes.addMimeType("text/x-haskell", "hs");
        MimeTypes.addMimeType("text/x-java", "java");
        MimeTypes.addMimeType("text/x-literate-haskell", "lhs");
        MimeTypes.addMimeType("text/x-makefile", new String[0]);
        MimeTypes.addMimeType("text/x-moc", "moc");
        MimeTypes.addMimeType("text/x-pascal", "p", "pas");
        MimeTypes.addMimeType("text/x-pcs-gcd", "gcd");
        MimeTypes.addMimeType("text/x-perl", "pl", "pm");
        MimeTypes.addMimeType("text/x-python", "py");
        MimeTypes.addMimeType("text/x-server-parsed-html", new String[0]);
        MimeTypes.addMimeType("text/x-setext", "etx");
        MimeTypes.addMimeType("text/x-sh", "sh");
        MimeTypes.addMimeType("text/x-tcl", "tcl", "tk");
        MimeTypes.addMimeType("text/x-tex", "tex", "ltx", "sty", "cls");
        MimeTypes.addMimeType("text/x-vcalendar", "vcs");
        MimeTypes.addMimeType("text/x-vcard", "vcf");
        MimeTypes.addMimeType("video/bmpeg", new String[0]);
        MimeTypes.addMimeType("video/bt656", new String[0]);
        MimeTypes.addMimeType("video/celb", new String[0]);
        MimeTypes.addMimeType("video/dl", "dl");
        MimeTypes.addMimeType("video/dv", "dif", "dv");
        MimeTypes.addMimeType("video/fli", "fli");
        MimeTypes.addMimeType("video/gl", "gl");
        MimeTypes.addMimeType("video/jpeg", new String[0]);
        MimeTypes.addMimeType("video/h261", new String[0]);
        MimeTypes.addMimeType("video/h263", new String[0]);
        MimeTypes.addMimeType("video/h263-1998", new String[0]);
        MimeTypes.addMimeType("video/h263-2000", new String[0]);
        MimeTypes.addMimeType("video/mp1s", new String[0]);
        MimeTypes.addMimeType("video/mp2p", new String[0]);
        MimeTypes.addMimeType("video/mp2t", new String[0]);
        MimeTypes.addMimeType("video/mp4", "mp4");
        MimeTypes.addMimeType("video/mp4v-es", new String[0]);
        MimeTypes.addMimeType("video/mpeg", "mpeg", "mpg", "mpe");
        MimeTypes.addMimeType("video/mpv", new String[0]);
        MimeTypes.addMimeType("video/nv", new String[0]);
        MimeTypes.addMimeType("video/parityfec", new String[0]);
        MimeTypes.addMimeType("video/pointer", new String[0]);
        MimeTypes.addMimeType("video/quicktime", "qt", "mov");
        MimeTypes.addMimeType("video/vnd.fvt", new String[0]);
        MimeTypes.addMimeType("video/vnd.motorola.video", new String[0]);
        MimeTypes.addMimeType("video/vnd.motorola.videop", new String[0]);
        MimeTypes.addMimeType("video/vnd.mpegurl", "mxu");
        MimeTypes.addMimeType("video/vnd.mts", new String[0]);
        MimeTypes.addMimeType("video/vnd.nokia.interleaved-multimedia", new String[0]);
        MimeTypes.addMimeType("video/vnd.vivo", new String[0]);
        MimeTypes.addMimeType("video/x-la-asf", "lsf", "lsx");
        MimeTypes.addMimeType("video/x-mng", "mng");
        MimeTypes.addMimeType("video/x-ms-asf", "asf", "asx");
        MimeTypes.addMimeType("video/x-ms-wm", "wm");
        MimeTypes.addMimeType("video/x-ms-wmv", "wmv");
        MimeTypes.addMimeType("video/x-ms-wmx", "wmx");
        MimeTypes.addMimeType("video/x-ms-wvx", "wvx");
        MimeTypes.addMimeType("video/x-msvideo", "avi");
        MimeTypes.addMimeType("video/x-sgi-movie", "movie");
        MimeTypes.addMimeType("video/x-flv", "flv");
        MimeTypes.addMimeType("x-conference/x-cooltalk", "ice");
        MimeTypes.addMimeType("x-world/x-vrml", "vrm", "vrml", "wrl");
    }
}

