/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;

public class StreamCopier {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private static int bufferSize = 65536;

    public static void setBufferSize(int bufferSize) {
        StreamCopier.bufferSize = bufferSize;
    }

    public static long copy(InputStream source, OutputStream destination, ProgressListener progressListener, long length) throws IOException {
        long remaining = length;
        byte[] buffer = new byte[bufferSize];
        long total = 0L;
        int read = 0;
        while (remaining == -1L || remaining > 0L) {
            read = source.read(buffer, 0, remaining > (long)bufferSize || remaining == -1L ? bufferSize : (int)remaining);
            if (read == -1) {
                if (length == -1L) {
                    return total;
                }
                throw new EOFException("stream reached eof");
            }
            destination.write(buffer, 0, read);
            if (remaining > -1L) {
                remaining -= (long)read;
            }
            total += (long)read;
            if (progressListener == null) continue;
            progressListener.onProgress(length - remaining, length);
        }
        return total;
    }

    public static long copy(InputStream source, OutputStream destination, long length) throws IOException {
        return StreamCopier.copy(source, destination, null, length);
    }

    public static long copy(InputStream source, OutputStream destination, ProgressListener progressListener) throws IOException {
        return StreamCopier.copy(source, destination, progressListener, -1L);
    }

    public static long copy(InputStream source, OutputStream destination) throws IOException {
        return StreamCopier.copy(source, destination, -1L);
    }

    public static long findLength(InputStream source) throws IOException {
        long length = 0L;
        byte[] buffer = new byte[bufferSize];
        int read = 0;
        while (read != -1) {
            read = source.read(buffer);
            if (read == -1) continue;
            length += (long)read;
        }
        return length;
    }

    public static interface ProgressListener
    extends EventListener {
        public void onProgress(long var1, long var3);
    }
}

