/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader {
    public static byte read(InputStream inputStream) throws IOException {
        int result2 = inputStream.read();
        if (result2 == -1) {
            throw new EOFException();
        }
        return (byte)result2;
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException {
        StreamReader.readFully(inputStream, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream inputStream, byte[] buffer, int position, int length) throws IOException {
        int read;
        for (int totalRead = 0; totalRead < length; totalRead += read) {
            read = inputStream.read(buffer, position + totalRead, length - totalRead);
            if (read != -1) continue;
            throw new EOFException();
        }
    }
}

