/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.telnet.Command;

public abstract class AbstractCommand
implements Command {
    private final String name;
    private final String briefDescription;
    private final List<String> detailedDescription = new ArrayList<String>();

    protected AbstractCommand(String name, String briefDescription) {
        this.name = name;
        this.briefDescription = briefDescription;
    }

    protected AbstractCommand(String name, String briefDescription, String ... detailedDescriptions) {
        this.name = name;
        this.briefDescription = briefDescription;
        for (String detailedDescription : detailedDescriptions) {
            this.detailedDescription.add(detailedDescription);
        }
    }

    protected AbstractCommand(String name, String briefDescription, List<String> detailedDescription) {
        this(name, briefDescription);
        this.detailedDescription.addAll(detailedDescription);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBriefDescription() {
        return this.briefDescription;
    }

    @Override
    public List<String> getDetailedDescription() {
        return this.detailedDescription;
    }
}

