/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.pterodactylus.util.object.Classes;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class CollectionSortFilter
implements Filter {
    private final Map<Class<?>, Comparator<?>> comparators = new HashMap();

    public <T> void addComparator(Class<T> clazz, Comparator<? super T> comparator) {
        this.comparators.put(clazz, comparator);
    }

    @Override
    public Object format(TemplateContext templateContext, Object data, Map<String, Object> parameters2) {
        if (data instanceof Collection) {
            ArrayList list = new ArrayList((Collection)data);
            if (!list.isEmpty()) {
                Class<?> firstElementClass = list.get(0).getClass();
                Class<?> comparatorClass = Classes.closest(firstElementClass, this.comparators.keySet());
                if (comparatorClass != null) {
                    Comparator<?> comparator = this.comparators.get(comparatorClass);
                    Collections.sort(list, comparator);
                } else {
                    Collections.sort(list);
                }
            }
            return list;
        }
        if (data instanceof Map) {
            return new TreeMap((Map)data);
        }
        return data;
    }
}

