/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.pterodactylus.util.collection.Pagination;
import net.pterodactylus.util.number.Numbers;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class PaginationFilter
implements Filter {
    @Override
    public Object format(TemplateContext templateContext, Object data, Map<String, Object> parameters2) {
        ArrayList list = null;
        if (data instanceof List) {
            list = (ArrayList)data;
        } else if (data instanceof Iterable) {
            Iterator iterator2 = ((Iterable)data).iterator();
            list = new ArrayList();
            while (iterator2.hasNext()) {
                list.add(iterator2.next());
            }
        } else {
            return data;
        }
        int pageSize = Numbers.safeParseInteger(parameters2.get("pageSize"), 25);
        int page = Numbers.safeParseInteger(parameters2.get("page"), 0);
        String paginationName = "pagination";
        if (parameters2.containsKey("pagination")) {
            paginationName = String.valueOf(parameters2.get("pagination"));
        }
        Pagination pagination = new Pagination(list, pageSize).setPage(page);
        templateContext.set(paginationName, pagination, true);
        return pagination.getItems();
    }
}

