/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.TemplateContext;

public class XmlFilter
implements Filter {
    private static final Map<Character, String> xmlEntities = new HashMap<Character, String>();

    @Override
    public String format(TemplateContext templateContext, Object data, Map<String, Object> parameters2) {
        StringBuilder xmlOutput = new StringBuilder();
        for (char c : data != null ? String.valueOf(data).toCharArray() : new char[]{}) {
            if (xmlEntities.containsKey(Character.valueOf(c))) {
                xmlOutput.append('&').append(xmlEntities.get(Character.valueOf(c))).append(';');
                continue;
            }
            if (c >= '\u0001' && c <= '\b' || c >= '\u000b' && c <= '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f') continue;
            xmlOutput.append(c);
        }
        return xmlOutput.toString();
    }

    static {
        xmlEntities.put(Character.valueOf('&'), "amp");
        xmlEntities.put(Character.valueOf('\''), "apos");
        xmlEntities.put(Character.valueOf('>'), "gt");
        xmlEntities.put(Character.valueOf('<'), "lt");
        xmlEntities.put(Character.valueOf('\"'), "quot");
    }
}

