/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.pterodactylus.util.number.Hex;
import net.pterodactylus.util.text.TextException;

public class StringEscaper {
    public static String persistString(String original) {
        if (original == null) {
            return "";
        }
        StringBuilder persistedString = new StringBuilder();
        persistedString.append(original.length()).append(':');
        for (char c : original.toCharArray()) {
            persistedString.append(Hex.toHex(c, 4));
        }
        return persistedString.toString();
    }

    public static String unpersistString(String persistedString) throws TextException {
        if (persistedString.length() == 0) {
            return null;
        }
        int colon = persistedString.indexOf(58);
        if (colon == -1) {
            throw new TextException("no colon in persisted string");
        }
        if ((persistedString.length() - (colon + 1)) % 4 != 0) {
            throw new TextException("invalid length of persisted string");
        }
        int length = -1;
        try {
            length = Integer.parseInt(persistedString.substring(0, colon));
        }
        catch (NumberFormatException nfe1) {
            throw new TextException("could not parse length", nfe1);
        }
        if (length < 0) {
            throw new TextException("invalid length: " + length);
        }
        StringBuilder unpersistedString = new StringBuilder(length);
        try {
            for (int charIndex = colon + 1; charIndex < persistedString.length(); charIndex += 4) {
                char c = (char)Integer.parseInt(persistedString.substring(charIndex, charIndex + 4), 16);
                unpersistedString.append(c);
            }
        }
        catch (NumberFormatException nfe1) {
            throw new TextException("invalid character in persisted string", nfe1);
        }
        return unpersistedString.toString();
    }

    public static List<String> parseLine(String line) throws TextException {
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean backslashed = false;
        ArrayList<String> words = new ArrayList<String>();
        boolean wordEmpty = true;
        StringBuilder currentWord = new StringBuilder();
        for (char c : line.toCharArray()) {
            if (c == '\"') {
                if (inSingleQuote || backslashed) {
                    currentWord.append(c);
                    backslashed = false;
                    continue;
                }
                inDoubleQuote ^= true;
                wordEmpty = false;
                continue;
            }
            if (c == '\'') {
                if (inDoubleQuote || backslashed) {
                    currentWord.append(c);
                    backslashed = false;
                    continue;
                }
                inSingleQuote ^= true;
                wordEmpty = false;
                continue;
            }
            if (c == '\\') {
                if (inSingleQuote || backslashed) {
                    currentWord.append(c);
                    backslashed = false;
                    continue;
                }
                backslashed = true;
                continue;
            }
            if (c == ' ') {
                if (inDoubleQuote || inSingleQuote || backslashed) {
                    currentWord.append(c);
                    backslashed = false;
                    continue;
                }
                if (currentWord.length() <= 0 && wordEmpty) continue;
                words.add(currentWord.toString());
                currentWord.setLength(0);
                wordEmpty = true;
                continue;
            }
            if (backslashed && c == 'n') {
                currentWord.append('\n');
            } else if (backslashed && c == 'r') {
                currentWord.append('\r');
            } else {
                currentWord.append(c);
            }
            backslashed = false;
        }
        if (inSingleQuote || inDoubleQuote || backslashed) {
            throw new TextException("open quote in line: " + line);
        }
        if (currentWord.length() > 0) {
            words.add(currentWord.toString());
        }
        return words;
    }

    public static String escapeWord(String word) {
        boolean containsLineBreak;
        if (word == null) {
            return "";
        }
        if (word.length() == 0) {
            return "\"\"";
        }
        boolean containsSingleQuote = word.indexOf(39) != -1;
        boolean containsDoubleQuote = word.indexOf(34) != -1;
        boolean containsBackslash = word.indexOf(92) != -1;
        boolean containsSpace = word.indexOf(32) != -1;
        boolean bl = containsLineBreak = word.indexOf(10) != -1;
        if (!(containsSingleQuote || containsDoubleQuote || containsBackslash || containsSpace)) {
            return word.replace("\n", "\\n").replace("\r", "\\r");
        }
        if (!containsDoubleQuote && !containsBackslash) {
            return "\"" + word.replace("\n", "\\n").replace("\r", "\\r") + "\"";
        }
        if (!containsSingleQuote && !containsLineBreak) {
            return "'" + word.replace("\n", "\\n").replace("\r", "\\r") + "'";
        }
        return word.replace("\\", "\\\\").replace(" ", "\\ ").replace("\"", "\\\"").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
    }

    public static String escapeWords(Collection<String> words) {
        StringBuilder wordBuilder = new StringBuilder();
        for (String word : words) {
            if (wordBuilder.length() > 0) {
                wordBuilder.append(' ');
            }
            wordBuilder.append(StringEscaper.escapeWord(word));
        }
        return wordBuilder.toString();
    }
}

