/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.time;

public class Duration {
    private final long duration;
    private final long weeks;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int milliseconds;

    public Duration(long duration) {
        this.duration = duration;
        this.milliseconds = (int)(duration % 1000L);
        this.seconds = (int)(duration / 1000L % 60L);
        this.minutes = (int)(duration / 60000L % 60L);
        this.hours = (int)(duration / 3600000L % 24L);
        this.days = (int)(duration / 86400000L % 7L);
        this.weeks = duration / 604800000L;
    }

    public int getDays() {
        return this.days;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getWeeks() {
        return this.weeks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showMilliseconds) {
        StringBuilder durationBuilder = new StringBuilder();
        if (this.milliseconds != 0 && showMilliseconds) {
            int ms = this.milliseconds;
            while (ms % 10 == 0) {
                ms /= 10;
            }
            durationBuilder.append(this.seconds).append('.').append(ms).append('s');
        } else if (this.seconds != 0) {
            durationBuilder.append(this.seconds).append('s');
        } else if (this.minutes == 0 && this.hours == 0 && this.days == 0 && this.weeks == 0L) {
            durationBuilder.append("0s");
        }
        if (this.minutes != 0) {
            durationBuilder.insert(0, "m ").insert(0, this.minutes);
        }
        if (this.hours != 0) {
            durationBuilder.insert(0, "h ").insert(0, this.hours);
        }
        if (this.days != 0) {
            durationBuilder.insert(0, "d ").insert(0, this.days);
        }
        if (this.weeks != 0L) {
            durationBuilder.insert(0, "w ").insert(0, this.weeks);
        }
        return durationBuilder.toString();
    }
}

