/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.io.StreamCopier;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.Request;
import net.pterodactylus.util.web.Response;

public class StaticPage<REQ extends Request>
implements Page<REQ> {
    private final Class<?> resourceClass;
    private final String pathPrefix;
    private final String resourcePathPrefix;
    private final String mimeType;

    public StaticPage(String pathPrefix, String resourcePathPrefix, String mimeType) {
        this(StaticPage.class, pathPrefix, resourcePathPrefix, mimeType);
    }

    public StaticPage(Class<?> resourceClass, String pathPrefix, String resourcePathPrefix, String mimeType) {
        this.resourceClass = resourceClass;
        this.pathPrefix = pathPrefix;
        this.resourcePathPrefix = resourcePathPrefix;
        this.mimeType = mimeType;
    }

    @Override
    public String getPath() {
        return this.pathPrefix;
    }

    @Override
    public boolean isPrefixPage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response handleRequest(REQ request, Response response) throws IOException {
        String path = ((Request)request).getUri().getPath();
        int lastSlash = path.lastIndexOf(47);
        String filename = path.substring(lastSlash + 1);
        InputStream fileInputStream = this.resourceClass.getResourceAsStream(this.resourcePathPrefix + filename);
        if (fileInputStream == null) {
            return response.setStatusCode(404).setStatusText("Not found.");
        }
        OutputStream contentOutputStream = response.getContent();
        try {
            StreamCopier.copy(fileInputStream, contentOutputStream);
        }
        finally {
            Closer.close(fileInputStream);
            Closer.close(contentOutputStream);
        }
        return response.setStatusCode(200).setStatusText("OK").setContentType(this.mimeType);
    }
}

