/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.text.Normalizer;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class JSONEmitter {
    private Configuration config;
    private UnicodeWriter writer;
    private boolean normalize;
    private Normalizer.Form normalizationForm;
    private CharacterMap characterMap;
    private Properties outputProperties;
    private CharacterSet characterSet;
    private boolean isIndenting;
    private int indentSpaces = 2;
    private int maxLineLength;
    private boolean first = true;
    private boolean afterKey = false;
    private int level;
    private final Stack<Boolean> oneLinerStack = new Stack();
    private boolean unfailing = false;
    private boolean mustClose = true;

    public JSONEmitter(PipelineConfiguration pipe, UnicodeWriter writer, Properties outputProperties) {
        this.config = pipe.getConfiguration();
        this.setOutputProperties(outputProperties);
        this.writer = writer;
    }

    public void setMustClose(boolean mustClose) {
        this.mustClose = mustClose;
    }

    public void setOutputProperties(Properties details) {
        String spaces;
        String max;
        this.outputProperties = details;
        if ("yes".equals(details.getProperty("indent"))) {
            this.isIndenting = true;
        }
        if ("yes".equals(details.getProperty("{http://saxon.sf.net/}unfailing"))) {
            this.unfailing = true;
        }
        if ((max = details.getProperty("{http://saxon.sf.net/}line-length")) != null) {
            try {
                this.maxLineLength = Integer.parseInt(max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((spaces = details.getProperty("{http://saxon.sf.net/}indent-spaces")) != null) {
            try {
                this.indentSpaces = Integer.parseInt(spaces);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String encoding = details.getProperty("encoding");
        try {
            this.characterSet = this.config.getCharacterSetFactory().getCharacterSet(encoding);
        }
        catch (XPathException e) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setNormalizationForm(Normalizer.Form form) {
        this.normalize = true;
        this.normalizationForm = form;
    }

    public void setCharacterMap(CharacterMap map) {
        this.characterMap = map;
    }

    public void writeKey(String key) throws XPathException {
        boolean oneLiner = this.oneLinerStack.peek();
        this.conditionalComma(false);
        this.emit('\"');
        this.emit(this.escape(key));
        this.emit("\":");
        if (this.isIndenting && !oneLiner) {
            this.emit(" ");
        }
        this.afterKey = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAtomicValue(AtomicValue item) throws XPathException {
        this.conditionalComma(false);
        if (item == null) {
            this.emit("null");
            return;
        } else if (item instanceof NumericValue) {
            NumericValue num = (NumericValue)item;
            if (num.isNaN()) {
                if (!this.unfailing) throw new XPathException("JSON has no way of representing NaN", "SERE0020");
                this.emit("NaN");
                return;
            } else if (Double.isInfinite(num.getDoubleValue())) {
                if (!this.unfailing) throw new XPathException("JSON has no way of representing Infinity", "SERE0020");
                this.emit(num.getDoubleValue() < 0.0 ? "-INF" : "INF");
                return;
            } else if (item instanceof IntegerValue) {
                this.emit(num.longValue() + "");
                return;
            } else if (num.isWholeNumber() && !num.isNegativeZero() && num.abs().compareTo(1000000000000000000L) < 0) {
                this.emit(num.longValue() + "");
                return;
            } else {
                this.emit(num.getStringValue());
            }
            return;
        } else if (item instanceof BooleanValue) {
            this.emit(item.getStringValue());
            return;
        } else {
            this.emit('\"');
            this.emit(this.escape(item.getStringValue()));
            this.emit('\"');
        }
    }

    public void startArray(boolean oneLiner) throws XPathException {
        this.emitOpen('[', oneLiner);
        ++this.level;
    }

    public void endArray() throws XPathException {
        this.emitClose(']', this.level--);
    }

    public void startMap(boolean oneLiner) throws XPathException {
        this.emitOpen('{', oneLiner);
        ++this.level;
    }

    public void endMap() throws XPathException {
        this.emitClose('}', this.level--);
    }

    private void emitOpen(char bracket, boolean oneLiner) throws XPathException {
        this.conditionalComma(true);
        this.oneLinerStack.push(oneLiner);
        this.emit(bracket);
        this.first = true;
        if (this.isIndenting && oneLiner) {
            this.emit(' ');
        }
    }

    private void emitClose(char bracket, int level) throws XPathException {
        boolean oneLiner = this.oneLinerStack.pop();
        if (this.isIndenting) {
            if (oneLiner) {
                this.emit(' ');
            } else {
                this.indent(level - 1);
            }
        }
        this.emit(bracket);
        this.first = false;
    }

    private void conditionalComma(boolean opening) throws XPathException {
        boolean actuallyIndenting;
        boolean wasFirst = this.first;
        boolean oneLiner = !this.oneLinerStack.isEmpty() && this.oneLinerStack.peek() != false;
        boolean bl = actuallyIndenting = this.isIndenting && this.level != 0 && !oneLiner;
        if (this.first) {
            this.first = false;
        } else if (!this.afterKey) {
            this.emit(',');
            if (oneLiner && this.isIndenting) {
                this.emit(' ');
            }
        }
        if (wasFirst && this.afterKey) {
            this.emit(' ');
        } else if (actuallyIndenting && !this.afterKey) {
            this.emit('\n');
            for (int i = 0; i < this.indentSpaces * this.level; ++i) {
                this.emit(' ');
            }
        }
        this.afterKey = false;
    }

    private void indent(int level) throws XPathException {
        this.emit('\n');
        for (int i = 0; i < this.indentSpaces * level; ++i) {
            this.emit(' ');
        }
    }

    private String escape(String cs) throws XPathException {
        if (this.characterMap != null) {
            int start;
            StringBuilder out = new StringBuilder(cs.length());
            String s = this.characterMap.map(StringView.of(cs).tidy(), true).toString();
            int prev = 0;
            while ((start = s.indexOf(0, prev)) >= 0) {
                out.append(this.simpleEscape(s.substring(prev, start)));
                int end = s.indexOf(0, start + 1);
                out.append(s, start + 1, end);
                prev = end + 1;
            }
            out.append(this.simpleEscape(s.substring(prev)));
            return out.toString();
        }
        return this.simpleEscape(cs);
    }

    private String simpleEscape(String cs) throws XPathException {
        if (this.normalize) {
            cs = Normalizer.normalize(cs, this.normalizationForm);
        }
        return JsonReceiver.escape(cs, false, c -> c < 31 || c >= 127 && c <= 159 || !this.characterSet.inCharset(c));
    }

    private void emit(String s) throws XPathException {
        assert (this.writer != null);
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    private void emit(char c) throws XPathException {
        assert (this.writer != null);
        try {
            this.writer.writeCodePoint(c);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public void close() throws XPathException {
        if (this.first) {
            this.emit("null");
        }
        if (this.writer != null) {
            try {
                if (this.mustClose) {
                    this.writer.close();
                } else {
                    this.writer.flush();
                }
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
    }
}

