/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.legend;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.point.NamedShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/legend/LollipopLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "fatten", "", "stickLength", "(DD)V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minimumKeySize", "radiusPx", "plot-base"})
public final class LollipopLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final double fatten;
    private final double stickLength;

    public LollipopLegendKeyElementFactory(double fatten, double stickLength) {
        this.fatten = fatten;
        this.stickLength = stickLength;
    }

    public /* synthetic */ LollipopLegendKeyElementFactory(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        if ((n & 2) != 0) {
            d2 = 5.0;
        }
        this(d, d2);
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        SvgGElement g = new SvgGElement();
        DoubleVector location2 = new DoubleVector(size.getX() / (double)2, (size.getY() - this.stickLength) / (double)2);
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        SvgSlimObject slimObject = PointShapeSvg.INSTANCE.create(pointShape, location2, p, this.fatten);
        SvgGElement circle = GeomBase.Companion.wrap(slimObject);
        g.children().add((Object)circle);
        double radius = this.radiusPx(p);
        SvgLineElement line = new SvgLineElement(location2.getX(), location2.getY() + radius, location2.getX(), location2.getY() + radius + this.stickLength);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)line, p, false, (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

            @NotNull
            public final Double invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((AesScaling)this.receiver).lineWidth(p0);
            }
        }, 4, null);
        g.children().add((Object)line);
        return g;
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape shape = pointShape;
        double shapeSize = shape.size(p, this.fatten);
        double strokeWidth = shape.strokeWidth(p);
        double size = shapeSize + strokeWidth + 2.0;
        return new DoubleVector(size, size);
    }

    private final double radiusPx(DataPointAesthetics p) {
        PointShape shape;
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape pointShape2 = shape = pointShape;
        double shapeCoeff = ((pointShape2 == NamedShape.STICK_PLUS ? true : pointShape2 == NamedShape.STICK_STAR) ? true : pointShape2 == NamedShape.STICK_CROSS) ? 0.0 : 1.0;
        return (shape.size(p, this.fatten) + shapeCoeff * shape.strokeWidth(p)) / 2.0;
    }

    public LollipopLegendKeyElementFactory() {
        this(0.0, 0.0, 3, null);
    }
}

